#ifndef OCRREQUEST_H
#define OCRREQUEST_H

#include <QtCore/QObject>
#include <QtCore/QUrl>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QtCore/QByteArray>
#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>
#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QHostAddress>
#include <QFile>
#include <stdio.h>
#include <QtGlobal>
#include <QtGui/QTextDocument>
#include <QString>
#include "packets.h"
#include "util.h"
#include <QHash>
#include <QComboBox>
#include <QTimer>

const QString g_translate_api_url = "http://ajax.googleapis.com/ajax/services/language/translate";
const QString g_http_referrer = "http://code.google.com/p/cs262aproject";
const QString g_API_key = "ABQIAAAAxV5BXsAxqWEmhZjXfDO9HBT7jf49mRgm7OFYO-uGOm32cmfFGhQvzH2mBxZ1stqNztc9gzOu59a9mQ";

enum RequestState{
    idle = 0,
    connecting_OCR_server,
    send_request_pkt,
    send_image,
    recv_resp_pkt,
    recv_resp_data,
    send_translate,
    recv_translate,
    retrans
};

class OCRRequest : public QObject
{
    Q_OBJECT
    QNetworkAccessManager * manager;
    RequestState state;
     QString m_input_file_path;
     uint m_total_recv;
    result_pkt res_pkt;
    char * m_resp_data;
    QString m_ip;
    qint16 m_port;
    bool m_need_to_cleanup;
    int m_lang;

public:
    QTcpSocket * server_socket;
    OCRRequest(QString ip, qint16 port, QString path);
    void MakeOCRRequest();
    bool SendRequest(QTcpSocket * s, char * file_path);
    char * ReceiveResults(QTcpSocket * server);
    void SetInputPath(QString path);
    QTimer timer;
public slots:
    void RecvTransResponse(QNetworkReply *reply);
    void WrapUp(QString result);
    void SendOCRReqPkt();
    void DispatchSend();
    void DispatchRecv();
    void Make_Trans_Request(QString, QString, QString);
    void Make_Retrans_Request(QString, QString, QString);
    void SetLang(QString lang);
    void TimedOut();
    void ConnectToHostError();
signals:
    void TransFinished(QString result);
    void OCR_finished(QString result);
    void TimedOutSignal(OCRRequest * req);
    void ErrorConnecting(OCRRequest * req);

};

#endif // OCRREQUEST_H
