/* 
 * Copyright (C) 2008 Piotr Pokora <piotrek.pokora@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIDGARD_HTTP_HOST_H
#define MIDGARD_HTTP_HOST_H

#include <glib-object.h>
#include "midgard_object.h"
#include "midgard_request_config.h"

G_BEGIN_DECLS

/* convention macros */
#define MIDGARD_TYPE_HTTP_HOST (midgard_http_host_get_type())
#define MIDGARD_HTTP_HOST(object)  \
	        (G_TYPE_CHECK_INSTANCE_CAST ((object),MIDGARD_TYPE_HTTP_HOST, MidgardHttpHost))
#define MIDGARD_HTTP_HOST_CLASS(klass)  \
	        (G_TYPE_CHECK_CLASS_CAST ((klass), MIDGARD_TYPE_HTTP_HOST, MidgardHttpHostClass))
#define MIDGARD_IS_HTTP_HOST(object)   \
	        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MIDGARD_TYPE_HTTP_HOST))
#define MIDGARD_IS_HTTP_HOST_CLASS(klass) \
	        (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDGARD_TYPE_HTTP_HOST))
#define MIDGARD_HTTP_HOST_GET_CLASS(obj) \
	        (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDGARD_TYPE_HTTP_HOST, MidgardHttpHostClass))

typedef struct _MidgardHttpHost MidgardHttpHost;
typedef struct _MidgardHttpHostClass MidgardHttpHostClass;
typedef struct _MidgardHttpHostPrivate MidgardHttpHostPrivate; 

struct _MidgardHttpHostClass{
	
	GObjectClass parent;
};

struct _MidgardHttpHost{

	GObject parent;

	/* < public > */
	const gchar *uri;
	const gchar *prefix;
	const gchar *name;
	guint port;
	MgdObject *host;
	MgdObject *style;
	MgdObject *root_page;
	gboolean auth_required;
	GList *argv;
	
	/* < private > */
	const gchar *possible_prefix;
	GList *urilist;
	MidgardConnection *mgd;
};

extern GType midgard_http_host_get_type(void);
 
extern MidgardHttpHost *midgard_http_host_new(
		MidgardConnection *mgd, const gchar *name, 
		guint port, const gchar *uri);

extern MgdObject *midgard_http_host_get_style(MidgardHttpHost *self);
extern MidgardRequestConfig *midgard_http_host_get_request_config(MidgardHttpHost *self);

G_END_DECLS

#endif /* MIDGARD_HTTP_HOST_H */
