/* 
 * Copyright (C) 2006, 2007, 2008 Piotr Pokora <piotrek.pokora@gmail.com>
 * Copyright (C) 2006 Jukka Zitting <jukka.zitting@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIDGARD_CONNECTION_H
#define MIDGARD_CONNECTION_H

#define GETTEXT_PACKAGE "midgard"
#include <glib/gi18n-lib.h>

#include "midgard_defs.h"
#include "midgard_config.h"
#include "midgard_request_config.h"

/* convention macros */
#define MIDGARD_TYPE_CONNECTION (midgard_connection_get_type())
#define MIDGARD_CONNECTION(object)  \
	        (G_TYPE_CHECK_INSTANCE_CAST ((object),MIDGARD_TYPE_CONNECTION, MidgardConnection))
#define MIDGARD_CONNECTION_CLASS(klass)  \
	        (G_TYPE_CHECK_CLASS_CAST ((klass), MIDGARD_TYPE_CONNECTION, MidgardConnectionClass))
#define MIDGARD_IS_CONNECTION(object)   \
	        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MIDGARD_TYPE_CONNECTION))
#define MIDGARD_IS_CONNECTION_CLASS(klass) \
	        (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDGARD_TYPE_CONNECTION))
#define MIDGARD_CONNECTION_GET_CLASS(obj) \
	        (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDGARD_TYPE_CONNECTION, MidgardConnectionClass))

typedef struct MidgardConnectionClass MidgardConnectionClass;
typedef struct _MidgardConnectionPrivate MidgardConnectionPrivate; 
typedef struct _MidgardConnectionCache MidgardConnectionCache;
typedef struct _midgardConnection midgard_connection;

struct MidgardConnectionClass{
	GObjectClass parent;

	/* class members */
	gboolean	(*open)			(MidgardConnection *mgd, const char *name, GError **error);
	gboolean	(*open_config) 		(MidgardConnection *mgd, MidgardConfig *config);
	void 		(*close) 		(MidgardConnection *mgd);
	gboolean 	(*set_sitegroup) 	(MidgardConnection *mgd, const gchar *guid);
	const gchar 	*(*get_sitegroup) 	(MidgardConnection *mgd);
	gboolean 	(*set_lang) 		(MidgardConnection *mgd, const char *language);
	const gchar 	*(*get_lang) 		(MidgardConnection *mgd);
	gboolean 	(*set_default_lang) 	(MidgardConnection *mgd, const char *language);
	const gchar 	*(*get_default_lang) 	(MidgardConnection *mgd);
	gboolean 	(*set_loglevel) 	(MidgardConnection *mgd, const gchar *levelstring, GLogFunc log_func);
	guint 		(*get_loglevel) 	(MidgardConnection *mgd);
	void 		(*set_loghandler) 	(MidgardConnection *mgd, guint loghandler);
	guint 		(*get_loghandler) 	(MidgardConnection *mgd);

	/* signals */
	void	(*error) 		(GObject *object);
	void	(*lang_changed) 	(GObject *object);
	void	(*sitegroup_changed)	(GObject *object);
	void	(*auth_changed) 	(GObject *object);
	void 	(*lost_provider)	(GObject *object);

	/* signals IDs */
	guint signal_id_error;
	guint signal_id_lang_changed;
	guint signal_id_sitegroup_changed;
	guint signal_id_auth_changed;
	guint signal_id_lost_provider;
};

struct MidgardConnection{

	/* < public > */
	GObject parent;
	gint errnum;
	gchar *errstr;
	GError *err;
	MidgardRequestConfig *rcfg;
	
	/* < private > */
	MidgardConnectionPrivate *priv;
	
	/* Legacy, FIXME, remove */	
	int lang;
	int default_lang;        
	gpointer person;	
	gboolean quota;	
};

GType			 midgard_connection_get_type			(void);
MidgardConnection 	*midgard_connection_new				(void);
gboolean 		 midgard_connection_open			(MidgardConnection *self, const gchar *name, GError **error);
GHashTable 		*midgard_connection_open_all			(gboolean userdir); 
gboolean 		 midgard_connection_open_config			(MidgardConnection *self, MidgardConfig *config);
gboolean 		 midgard_connection_open_from_file		(MidgardConnection *self, const gchar *filepath, GError **error);
void 			 midgard_connection_close			(MidgardConnection *self);
gboolean 		 midgard_connection_set_sitegroup		(MidgardConnection *self, const gchar *name);
const gchar 		*midgard_connection_get_sitegroup		(MidgardConnection *self);
gboolean 		 midgard_connection_set_lang			(MidgardConnection *self, const gchar *language);
gboolean 		 midgard_connection_set_default_lang		(MidgardConnection *self, const gchar *language);
const gchar 		*midgard_connection_get_lang			(MidgardConnection *self);
const gchar 		*midgard_connection_get_default_lang		(MidgardConnection *self);
gboolean 		 midgard_connection_set_loglevel		(MidgardConnection *self, const gchar *level, GLogFunc log_func);
guint 			 midgard_connection_get_loglevel		(MidgardConnection *self);
void 			 midgard_connection_set_loghandler		(MidgardConnection *self, guint loghandler);
guint 			 midgard_connection_get_loghandler		(MidgardConnection *self);
const gchar 		*midgard_connection_get_sitegroup_from_id	(MidgardConnection *self, guint id);
guint 			 midgard_connection_get_sitegroup_id		(MidgardConnection *self);
const gchar 		*midgard_connection_get_lang_from_id		(MidgardConnection *self, guint id);
guint 			 midgard_connection_get_lang_id			(MidgardConnection *self, const gchar *language);
gint 			 midgard_connection_get_error			(MidgardConnection *self);
void 			 midgard_connection_set_error			(MidgardConnection *self, gint errcode);
const gchar 		*midgard_connection_get_error_string		(MidgardConnection *self);
MidgardUser 		*midgard_connection_get_user			(MidgardConnection *self);
gboolean 		 midgard_connection_set_request_config		(MidgardConnection *self, MidgardRequestConfig *rcfg);
const MidgardRequestConfig *midgard_connection_get_request_config	(MidgardConnection *self);
MidgardConnection 	*midgard_connection_copy			(MidgardConnection *self);
gboolean		midgard_connection_reopen			(MidgardConnection *self);
const GObject 		**midgard_connection_list_languages		(MidgardConnection *self, guint *n_objects);

#define MGD_GET_LANG(mgd) \
	midgard_connection_get_lang(mgd)
#define MGD_GET_DEFAULT_LANG(mgd) \
	midgard_connection_get_default_lang(mgd)

#define MGD_GET_LANG_ID(mgd) \
	midgard_connection_get_lang_id(mgd, midgard_connection_get_lang(mgd))
#define MGD_GET_DEFAULT_LANG_ID(mgd) \
	midgard_connection_get_lang_id(mgd, midgard_connection_get_default_lang(mgd))

/*
 * This is a part of public API , however it shouldn't be used in any
 * application unless you really know what you are doing.
 */
extern MidgardConnection *midgard_connection_struct_new(void);

extern MidgardConnection *midgard_connection_struct2gobject(MidgardConnection *conn);

extern gboolean midgard_connection_struct_open_config(
	MidgardConnection *mgd, MidgardConfig *config);

extern void midgard_connection_struct_free(MidgardConnection *self);

#endif /* MIDGARD_CONNNECTION_H */
