Name:      midgard2-core
Version:   9.03.0
Release:   4.ent
Summary:   Midgard Core
Packager:  %{packager}

License:   LGPL
Group:     Networking/Daemons
URL:       http://www.midgard-project.org/
Source:    midgard2-core-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

BuildRequires: glib2-devel >= 2.12
BuildRequires: libxml2-devel >= 2.6.14
BuildRequires: libgda-devel

Requires: glib2 >= 2.4.7
Requires: libxml2 >= 2.6.14
Requires: libgda

#Note dbus package has different naming convention
%if 0%{?suse_version}

BuildRequires: dbus-1-glib-devel
Requires:      dbus-1-glib
Requires:      dbus-1

BuildRequires: libopenssl-devel

%else

BuildRequires: dbus-devel
BuildRequires: dbus-glib-devel
Requires:      dbus
Requires:      dbus-glib

BuildRequires: openssl-devel

%endif

Obsoletes:  midgard-lib
Provides:   midgard-lib

PreReq: grep
PreReq: glibc

%description
Midgard Core is the heart of the Midgard Framework, a free platform for
web application development, providing the glue between the popular
LAMP components, giving you the freedom to create your solutions in an
open environment.

Midgard Core contains the Midgard Library, providing object handling,
access and user management.

%package devel
Group:    Development/Libraries
Summary:  Files needed for building Midgard applications

Requires: midgard2-core = %{version}

%description devel
The midgard-core devel package contains files needed for building
Midgard applications. If you need to compile your own applications
or want to build the Apache / PHP modules, you will need to install
this package.

%prep
%setup -n %{name}-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure \
    --prefix=%{_prefix} \
    --libdir=%{_libdir}  
%{__make} %{?_smp_mflags} \
    OPTIMIZE="%{optflags}" 

%install
%{__make} install DESTDIR=%{buildroot}
%{__chmod} 755 %{buildroot}%{_prefix}/include

%post
%{__grep} -v '^%{_libdir}$' /etc/ld.so.conf | %{__grep} -v '^%{_libdir}/$' > ld.so.conf
/sbin/ldconfig

%postun
/sbin/ldconfig
 
%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS
%doc README
%{_bindir}/midgard2-query
%{_bindir}/midgard2-schema
%{_libdir}/libmidgard-2.0.so.2009
%{_libdir}/libmidgard-2.0.so.2009.3.0
%{_sysconfdir}/midgard-2.0/conf.d/midgard.conf.example
%{_mandir}/man1/midgard2-query.1.gz
%{_mandir}/man1/midgard2-schema.1.gz
%{_datadir}/midgard-2.0/MgdObjects.xml
%{_datadir}/midgard-2.0/midgard.conf.example
%{_datadir}/midgard-2.0/schema/README.txt
%{_datadir}/midgard-2.0/README.txt
%{_datadir}/midgard-2.0/midgard_initial_database.xml

%files devel
%defattr(-,root,root)
%{_includedir}/midgard-2.0/midgard/midgard_config.h
%{_includedir}/midgard-2.0/midgard/midgard_config_auto.h
%{_includedir}/midgard-2.0/midgard/midgard_connection.h
%{_includedir}/midgard-2.0/midgard/midgard_datatypes.h
%{_includedir}/midgard-2.0/midgard/midgard_defs.h
%{_includedir}/midgard-2.0/midgard/midgard_error.h
%{_includedir}/midgard-2.0/midgard/midgard_metadata.h
%{_includedir}/midgard-2.0/midgard/midgard_object.h
%{_includedir}/midgard-2.0/midgard/midgard_object_parameter.h
%{_includedir}/midgard-2.0/midgard/midgard_quota.h
%{_includedir}/midgard-2.0/midgard/midgard_reflection_property.h
%{_includedir}/midgard-2.0/midgard/midgard_replicator.h
%{_includedir}/midgard-2.0/midgard/midgard_schema.h
%{_includedir}/midgard-2.0/midgard/midgard_timestamp.h
%{_includedir}/midgard-2.0/midgard/midgard_type.h
%{_includedir}/midgard-2.0/midgard/query_builder.h
%{_includedir}/midgard-2.0/midgard/uuid.h
%{_includedir}/midgard-2.0/midgard/midgard.h
%{_includedir}/midgard-2.0/midgard/guid.h
%{_includedir}/midgard-2.0/midgard/midgard_blob.h
%{_includedir}/midgard-2.0/midgard/midgard_collector.h
%{_includedir}/midgard-2.0/midgard/midgard_dbobject.h
%{_includedir}/midgard-2.0/midgard/midgard_dbus.h
%{_includedir}/midgard-2.0/midgard/midgard_object_attachment.h
%{_includedir}/midgard-2.0/midgard/midgard_sitegroup.h
%{_includedir}/midgard-2.0/midgard/midgard_user.h
%{_includedir}/midgard-2.0/midgard/midgard_http_host.h
%{_includedir}/midgard-2.0/midgard/midgard_object_class.h
%{_includedir}/midgard-2.0/midgard/midgard_request_config.h
%{_includedir}/midgard-2.0/midgard/midgard_tree.h
%{_includedir}/midgard-2.0/midgard/midgard_utils.h
%{_libdir}/libmidgard-2.0.a
%{_libdir}/libmidgard-2.0.la
%{_libdir}/libmidgard-2.0.so
%{_libdir}/pkgconfig/midgard-2.0.pc

%changelog
* Thu Oct 09 2008 Piotr Pokora <piotrek.pokora@gmail.com> 9.03.0beta1  
- Initial


