/* 
 * Copyright (C) 2006, 2008 Piotr Pokora <piotrek.pokora@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIDGARD_REQUEST_CONFIG_H
#define MIDGARD_REQUEST_CONFIG_H

#include <glib-object.h>

G_BEGIN_DECLS

/* convention macros */
#define MIDGARD_TYPE_REQUEST_CONFIG (midgard_request_config_get_type())
#define MIDGARD_REQUEST_CONFIG(object)  \
	        (G_TYPE_CHECK_INSTANCE_CAST ((object),MIDGARD_TYPE_REQUEST_CONFIG, MidgardRequestConfig))
#define MIDGARD_REQUEST_CONFIG_CLASS(klass)  \
	        (G_TYPE_CHECK_CLASS_CAST ((klass), MIDGARD_TYPE_REQUEST_CONFIG, MidgardRequestConfigClass))
#define MIDGARD_IS_REQUEST_CONFIG(object)   \
	        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MIDGARD_TYPE_REQUEST_CONFIG))
#define MIDGARD_IS_REQUEST_CONFIG_CLASS(klass) \
	        (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDGARD_TYPE_REQUEST_CONFIG))
#define MIDGARD_REQUEST_CONFIG_GET_CLASS(obj) \
	        (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDGARD_TYPE_REQUEST_CONFIG, MidgardRequestConfigClass))

typedef struct _MidgardRequestConfig MidgardRequestConfig;
typedef struct _MidgardRequestConfigClass MidgardRequestConfigClass;
typedef struct _MidgardRequestConfigPrivate MidgardRequestConfigPrivate; 

struct _MidgardRequestConfigClass{
	
	GObjectClass parent;
};

struct _MidgardRequestConfig{
        GObject parent;

        /* < public > */
        GObject *host;
        GObject *page;
        GObject *style;
        const GObject **pages;
        const gchar *uri;
        gboolean auth_required;
        gboolean is_auth;
        GValueArray *argv;
        gint argc;
};

GType midgard_request_config_get_type(void);
 
MidgardRequestConfig *midgard_request_config_new(const gchar *uri);
gboolean midgard_request_config_set_host(MidgardRequestConfig *self, GObject *host);
gboolean midgard_request_config_set_style(MidgardRequestConfig *self, GObject *style);
gboolean midgard_request_config_set_page(MidgardRequestConfig *self, GObject *page);
gboolean midgard_request_config_set_pages(MidgardRequestConfig *self, GObject **pages);
gboolean midgard_request_config_set_auth(MidgardRequestConfig *self, gboolean auth);
gboolean midgard_request_config_set_argv(MidgardRequestConfig *self, GValueArray *argv);
gboolean midgard_request_config_set_argc(MidgardRequestConfig *self, guint argc);

GObject *midgard_request_config_get_host(MidgardRequestConfig *self);
GObject *midgard_request_config_get_style(MidgardRequestConfig *self);
GObject *midgard_request_config_get_page(MidgardRequestConfig *self);
const GObject **midgard_request_config_get_pages(MidgardRequestConfig *self);
gboolean midgard_request_config_get_auth(MidgardRequestConfig *self);
GValueArray *midgard_request_config_get_argv(MidgardRequestConfig *self);
guint midgard_request_config_get_argc(MidgardRequestConfig *self);
const gchar *midgard_request_config_get_uri(MidgardRequestConfig *self);

G_END_DECLS

#endif /* MIDGARD_REQUEST_CONFIG_H */
