/* 
 * Copyright (C) 2005 Piotr Pokora <piotr.pokora@infoglob.pl>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef MIDGARD_METADATA_H
#define MIDGARD_METADATA_H

/**
 * \defgroup midgard_metadata Midgard Metadata 
 *
 * Midgard Metadata Class provides unified common data for all classes 
 * registered in Midgard Schema ( MgdSchema ).
 * Midgard Metadata objects are automatically created when any  Midgard 
 * Schema class instance is created. However it is possible to  create 
 * standalone metadata object , it's not used in practice.
 * Midgard Metadata object are designed to be fully usefull with any object 
 * instance. 
 * 
 */

#include <glib-object.h>
#include "midgard_object.h"
#include "midgard_dbobject.h"

/* convention macros */
#define MIDGARD_TYPE_METADATA        (midgard_metadata_get_type ())
#define MIDGARD_METADATA(obj)        (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                    MIDGARD_TYPE_METADATA, MidgardMetadata))
#define MIDGARD_METADATA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                    MIDGARD_TYPE_METADATA, MidgardMetadataClass))
#define MIDGARD_IS_METADATA(obj)     (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDGARD_TYPE_METADATA))
#define MIDGARD_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDGARD_TYPE_METADATA))
#define MIDGARD_METADATA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                    MIDGARD_TYPE_METADATA, MidgardMetadataClass))

GType midgard_metadata_get_type (void);

struct MidgardMetadataClass {
	GObjectClass parent;
	MidgardDBObjectPrivate *dbpriv;
	
	guint signal_set_created;
	guint signal_set_updated;
	
	void (*set_created) (MgdObject *self);
	void (*set_updated) (MgdObject *self);	
};

typedef struct _MidgardMetadataPrivate MidgardMetadataPrivate;

struct MidgardMetadata {
	GObject parent;	
	MidgardDBObjectPrivate *dbpriv;
	MidgardMetadataPrivate *priv;
};

MidgardMetadata *midgard_metadata_new(MgdObject *object);

#endif /* MIDGARD_METADATA_H */
