#include "twitter.h"
#include <microfeed-common/microfeedprotocol.h>

void do_authentication(MicrofeedPublisher* publisher, MicrofeedHttp* http) {
	char* login;
	char* password;
	char* auth;

	if ((login = microfeed_publisher_get_setting_value(publisher, "authentication.login", NULL)) &&
	    (password = microfeed_publisher_get_setting_value(publisher, "authentication.password", NULL))) {
		auth = microfeed_util_string_concatenate(login, ":", password, NULL);
		microfeed_http_set_basic_authentication(http, auth);
		free(auth);
	}
}

MicrofeedError* check_if_error(MicrofeedJson* json) {
	MicrofeedError* error = NULL;
	const char* string;
	
	if ((string = microfeed_json_get_as_string(json, "error"))) {
		error = microfeed_error_new(MICROFEED_ERROR_FROM_SERVICE, string);
	}
	
	return error;
}
