
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "MyClass.h"

#include <QtCore/QCoreApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QDebug>

#if defined(Q_OS_SYMBIAN) && defined(ORIENTATIONLOCK)
#include <eikenv.h>
#include <eikappui.h>
#include <aknenv.h>
#include <aknappui.h>
#endif // Q_OS_SYMBIAN && ORIENTATIONLOCK

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent),
      ui(new Ui::MainWindow), myClass(new MyClass)
{
    initialCallID = "Private number";
    initialCallerPicPath = "qrc:/caller_image.png";
    initialCallerRingtonePath = "/home/user/MyDocs/.sounds/Ringtones/low.aac";
    initialCallWallpaper = "Default";

    ui->setupUi(this);
    ui->declarativeView->setResizeMode(QDeclarativeView::SizeRootObjectToView);

    QDeclarativeContext *context = ui->declarativeView->rootContext();
    //MyClass myClass;
    context->setContextProperty("callHelper", myClass);

    ui->declarativeView->setSource(QUrl("qrc:/main.qml"));

/*
#if defined(Q_WS_MAEMO_5)|| defined(Q_WS_HILDON)
    view.setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
#endif
    view.setWindowTitle("Call");
*/


   QObject::connect((QObject*)ui->declarativeView->rootObject(), SIGNAL(callEnd()), this, SLOT(rejectButtonClicked()));
   QObject::connect((QObject*)ui->declarativeView->rootObject(), SIGNAL(showMax()), this, SLOT(displayFakeCallMaximized()));
   QObject::connect(myClass, SIGNAL(setDefaults()), (QObject*)ui->declarativeView->rootObject(), SLOT(setDefaults()));
    //QObject::connect((QObject*)view.engine(), SIGNAL(quit()), &app, SLOT(quit()));
    //QObject::connect(rootObject, SIGNAL(callAnswered()), &view, SLOT(showFullScreen()));
    //QObject::connect(rootObject, SIGNAL(startVibration()), &myClass, SLOT(startVibration()));
    //QObject::connect(rootObject, SIGNAL(stopVibration()), &myClass, SLOT(stopVibration()));
   //myClass->setRingToneLoop();
   unLockN900();
   displayFakeCallMaximized();
}

MainWindow::~MainWindow()
{
    delete ui;
    myClass->stopVibration();
    delete myClass;
}

void MainWindow::displayFakeCallMaximized(){
    showFullScreen();
    showMaximized();
}

void MainWindow::rejectButtonClicked()
{
    close();
}

void MainWindow::setCallerNameLabel(QString name){
    qDebug("Name given: ");
    qDebug()<< name;
    if (name.isEmpty()){
       // myClass->setCallID("Private number");
    }
    else
        initialCallID = name;
}

void MainWindow::setCallerPicLabel(QString picpath){
    qDebug("Pic path given: ");
    qDebug()<< picpath;
    if (picpath.isEmpty() || picpath.toLower() == "default"){
       // myClass->setCallerPicPath("qrc:/caller_image.png");
    }
    else
        initialCallerPicPath = "file://"+picpath;
}

void MainWindow::setCallRingTone(QString tonepath){
    qDebug("Ringtone path given: ");
    qDebug()<< tonepath;
    if (tonepath.isEmpty())
    {}
    else{
        initialCallerRingtonePath= tonepath;
    }
}

void MainWindow::setCallWallpaper(QString wallpaperpath){
    qDebug("Wallpaper path given: ");
    qDebug()<< wallpaperpath;
    if (wallpaperpath.isEmpty())
    {}
    else{
        initialCallWallpaper = "file://"+wallpaperpath;
    }
}

void MainWindow::setCallerDefaults(){
    qDebug("Calling myClass->setCallerDefaults");
    myClass->setCallerDefaults(initialCallID, initialCallerPicPath, initialCallerRingtonePath, initialCallWallpaper);
}

void MainWindow::unLockN900(){
    #ifdef Q_WS_MAEMO_5
    mDbusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                         MCE_REQUEST_IF, QDBusConnection::systemBus(),
                         this);
    mDbusInterface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "unlocked");
    #endif
}

void MainWindow::setOrientation(Orientation orientation)
{
#ifdef Q_OS_SYMBIAN
    if (orientation != Auto) {
#if defined(ORIENTATIONLOCK)
        const CAknAppUiBase::TAppUiOrientation uiOrientation =
                (orientation == LockPortrait) ? CAknAppUi::EAppUiOrientationPortrait
                    : CAknAppUi::EAppUiOrientationLandscape;
        CAknAppUi* appUi = dynamic_cast<CAknAppUi*> (CEikonEnv::Static()->AppUi());
        TRAPD(error,
            if (appUi)
                appUi->SetOrientationL(uiOrientation);
        );
#else // ORIENTATIONLOCK
        qWarning("'ORIENTATIONLOCK' needs to be defined on Symbian when locking the orientation.");
#endif // ORIENTATIONLOCK
    }
#elif defined(Q_WS_MAEMO_5)
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case LockPortrait:
        attribute = Qt::WA_Maemo5PortraitOrientation;
        break;
    case LockLandscape:
        attribute = Qt::WA_Maemo5LandscapeOrientation;
        break;
    case Auto:
    default:
        attribute = Qt::WA_Maemo5AutoOrientation;
        break;
    }
    setAttribute(attribute, true);
#else // Q_OS_SYMBIAN
    Q_UNUSED(orientation);
#endif // Q_OS_SYMBIAN
}
