#ifndef MYCLASS_H
#define MYCLASS_H

#include <QObject>
#include <QVariant>
#include <phonon>
#include <QtDBus>

#ifdef Q_WS_MAEMO_5
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif

#include <QDebug>

class MyClass : public QObject
{
    Q_OBJECT

public:
    MyClass() {}
    int callDuration;
    QString ringTonePath;
    QString callID;
    QString callerPicPath;
    QString callerRingtonePath;
    QString wallPaperPath;

private:
    QDBusInterface *mDbusInterface;
    Phonon::MediaObject *mediaObject;

public slots:
    void getData() {
        QString text("New data");
        emit data(QVariant(text));
    }

    void setCallerDefaults(const QString &caller, const QString &pic, const QString &rtone, const QString &wallpaper){
        callID = caller;
        callerPicPath = pic;
        callerRingtonePath = rtone;
        wallPaperPath = wallpaper;
        qDebug("Sending setCallerDefaults signal");
        emit setDefaults(); //(QVariant(callID), QVariant(callerPicPath), QVariant(callerRingtonePath));
    }

    void startVibration(){
        qDebug("Reached startVibration");
        #ifdef Q_WS_MAEMO_5
            mDbusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                 MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                 this);
            mDbusInterface->call(MCE_ENABLE_VIBRATOR);

            mDbusInterface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
            mDbusInterface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "unlocked");

        #endif
    }

    void stopVibration(){
        qDebug("Reached stopVibration");
        #ifdef Q_WS_MAEMO_5
            mDbusInterface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");

        #endif
    }

    void repeatRingTone()
    {
        qDebug("Reached repeatRingTone");
        mediaObject->setCurrentSource(Phonon::MediaSource(ringTonePath));
        mediaObject->play();
    }

    void startRingtone(const QString &tonePath){
        ringTonePath = tonePath;
        qDebug("Reached startRingtone");
        mediaObject = new Phonon::MediaObject(this);
        Phonon::AudioOutput *audioOutput =
        new Phonon::AudioOutput(Phonon::MusicCategory, this);
        Phonon::Path path = Phonon::createPath(mediaObject, audioOutput);
        //QString ringTonePath = tonePath.toString();
        mediaObject->setCurrentSource(Phonon::MediaSource(tonePath));
        mediaObject->play();
        qDebug()<<tonePath;
        connect(mediaObject, SIGNAL(finished()), this, SLOT(repeatRingTone()));
    }

    void setRingToneLoop(const QString &tonePath){

    }

    void stopRingtone(){
        qDebug("Reached stopRingtone");
        mediaObject->stop();
    }

    void callAnswered(){
        callDuration = 0;
    }

    void setCallID(const QString &callerID){
        callID=callerID;
        qDebug("Caller ID set to: ");
        qDebug()<<callID;
    }

    void setCallerPicPath(const QString &picPath){
        callerPicPath=picPath;
        qDebug("Caller pic path set to: ");
        qDebug()<<callerPicPath;
    }

    void setCallRingTone(const QString &ringTone){
        callerRingtonePath=ringTone;
        qDebug("Caller ring tone set to: ");
        qDebug()<<callerRingtonePath;
    }

    QString getCallID(){
        return callID;
        qDebug("Returning call id: ");
        qDebug()<<callID;
    }

    QString getCallerPicPath(){
        return callerPicPath;
        qDebug("Returning pic path: ");
        qDebug()<<callerPicPath;
    }

    QString getRingTone(){
        return callerRingtonePath;
    }

    QString getWallPaperPath(){
        return wallPaperPath;
    }

signals:
    void data(QVariant data);
    void setDefaults();
    //void setDefaults(QVariant cid, QVariant pic, QVariant rtone);
};


#endif // MYCLASS_H
