/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1
import com.meego 1.0

Dialog {
    id: entryShowDialog

    anchors.fill: parent

    property alias name: name.text
    property alias userName: userName.text
    property alias password: password.text
    property alias notes: notes.text

    content:Item {
      anchors.fill: parent

      Text {id: name; font.pixelSize: 40; font.bold: true; anchors.horizontalCenter: parent.horizontalCenter; anchors.bottom: grid.top; anchors.bottomMargin: 30; color: "white"}

      Grid{
          id: grid

          anchors.bottom: notesLabel.top
          anchors.bottomMargin: 30
          anchors.horizontalCenter: parent.horizontalCenter

          columns: 2
          spacing: 5

          Label {text: "User Name: "; font.pixelSize: 30; color: "lightgray"}
          Label {id: userName; font.pixelSize: 30; color: "white"}
          Label {text: "Password: "; font.pixelSize: 30; color: "lightgray"}
          Label {id: password; font.pixelSize: 30; color: "white"}
      }

      Label {id: notesLabel; text: "Notes"; anchors.centerIn: parent; anchors.top: grid.bottom; anchors.topMargin: 30; font.pixelSize: 30; color: "lightgray"}
      Label {id: notes; anchors.horizontalCenter: parent.horizontalCenter; anchors.top: notesLabel.bottom; anchors.topMargin: 10; font.pixelSize: 30; color: "white"}
    }
}
