/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.0
import meepasswords 1.0

Rectangle{
    id: main

    onRotationChanged: {
        console.log("Rotation changed...");
    }

    anchors.fill: parent

    color: "white"

    Component.onCompleted: {
        console.debug("Opening storage...")
        entryStorage.openStorage();
    }

    Component.onDestruction: {
        console.debug("Shutting down...");
    }

    onStateChanged: {
        console.log("State changed: " + state);
    }

    states: [
        State {
            name: "NewPassword"
            PropertyChanges {target: passwordInputPage;
                visible: true;
                text: qsTr("Please enter a new password. "
                           + "Please keep the password at a safe place. "
                           + "There is no way to recover a lost password.");
                password: "";
                onClicked: {
                    entryStorage.setPassword(passwordInputPage.password);
                    main.state = "LoginSuccess";
                }
            }
            PropertyChanges {
                target: mainPage;
                visible: false;
            }
        },
        State {
            name: "EnterPassword"
            PropertyChanges {target: passwordInputPage;
                visible: true;
                text: qsTr("Enter Password:");
                password: "";
                onClicked: {
                    entryStorage.loadAndDecryptData(passwordInputPage.password, entryListModel);
                }
            }
            PropertyChanges {
                target: mainPage;
                visible: false;
            }
        },
        State {
            name: "WrongPassword"
            PropertyChanges {target: passwordInputPage;
                visible: true;
                text: qsTr("You entered a wrong password. Please reenter Password:");
                password: "";
                onClicked: {
                    entryStorage.loadAndDecryptData(passwordInputPage.password, entryListModel);
                }
            }
            PropertyChanges {
                target: mainPage;
                visible: false;
            }
        },
        State {
            name: "LoginSuccess"
            PropertyChanges {
                target: passwordInputPage;
                visible: false;
            }
            PropertyChanges {
                target: mainPage;
                visible: true;
            }
        }

    ]

    PasswordInputPage{
        id: passwordInputPage
    }

    MainPage{
        id: mainPage
    }

    EntryStorage {
        id: entryStorage

        onStorageOpenSuccess: state = "EnterPassword"
        onStorageOpenSuccessNewPassword: state = "NewPassword"

        onDecryptionFailed: state = "WrongPassword"
        onDecryptionSuccess: state = "LoginSuccess"
        onNewFileOpened: state = "LoginSuccess"

        onOperationFailed: {
            errorDialog.message = message;
            errorDialog.open();
        }
    }

    EntryListModel {
        id: entryListModel

        onChanged: entryStorage.storeModel(entryListModel)
    }
}


