/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ENTRYSTORAGE_H
#define ENTRYSTORAGE_H

#include <QObject>
#include <QStringList>

#ifdef MEEGO_EDITION_HARMATTAN
#include <aegis_storage.h>
#endif

#include <QtCrypto>

#include <entrylistmodel.h>

#define DEFAULT_STORAGE "MeePasswords_DefaultStorage"
#define ENCRYPTED_FILE "/encrypted.raw"
#define CIPHER_TYPE "aes256"
#define CIPHER_MODE QCA::Cipher::CBC
#define CIPHER_PADDING QCA::Cipher::PKCS7

class EntryStorage : public QObject
{
    Q_OBJECT
public:
    explicit EntryStorage(QObject *parent = 0);
    ~EntryStorage();

    Q_INVOKABLE bool equalsStoredPassword(QString password);

signals:
    void decryptionFailed();
    void decryptionSuccess();
    void newFileOpened();

    void operationFailed(QString message);

    void storageOpenSuccess();
    void storageOpenSuccessNewPassword();

public slots:
    void loadAndDecryptData(QString password, EntryListModel *model);
    void openStorage();
    void setPassword(QString password);
    void storeModel(EntryListModel *model);

private:
#ifdef MEEGO_EDITION_HARMATTAN
    aegis::storage *aegisStorage;
#endif

    QCA::Initializer *initializer;
    QCA::SymmetricKey *key;
};

#endif // ENTRYSTORAGE_H
