/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1
import com.meego 1.0
import meepasswords 1.0

Dialog {
    id: passwordChangeDialog

    anchors.fill: parent

    onStatusChanged: {
        if(status === DialogStatus.Opening){
            oldPassword.text = "";
            newPassword.text = "";
        }
    }

    Dialog{
        id: informationDialog
        anchors.fill: parent

        property alias text: message.text

        Item {
            anchors.fill: parent

            Text {id: message; font.pixelSize: 30; color: "white"; anchors.centerIn: parent; horizontalAlignment: Text.AlignHCenter; wrapMode: Text.Wrap}
        }
    }

    content: Item {
        anchors.centerIn: parent

        Text {id: name; text: "Change Password"; font.pixelSize: 40; font.bold: true; anchors.bottom: oldPasswordLabel.top; anchors.bottomMargin: 30; anchors.horizontalCenter: parent.horizontalCenter; color: "white"}

        Label {id: oldPasswordLabel; text: "Old Password: "; font.pixelSize: 30; color: "lightgray"; anchors.bottom: oldPassword.top; anchors.horizontalCenter: parent.horizontalCenter}
        TextField {id: oldPassword; anchors.bottom: newPasswordLabel.top; anchors.bottomMargin: 10; anchors.horizontalCenter: parent.horizontalCenter; echoMode: TextInput.Password}
        Label {id: newPasswordLabel; text: "New Password: "; font.pixelSize: 30; color: "lightgray"; anchors.bottom: newPassword.top; anchors.horizontalCenter: parent.horizontalCenter}
        TextField {id: newPassword; anchors.centerIn: parent; anchors.horizontalCenter: parent.horizontalCenter; echoMode: TextInput.Password}

        Button{id: okButton; text: "OK"; anchors.top: newPassword.bottom; anchors.topMargin: 30; anchors.horizontalCenter: parent.horizontalCenter; platformStyle: ButtonStyle{ inverted: true }
            onClicked: {
                if(entryStorage.equalsStoredPassword(oldPassword.text)){
                    entryStorage.setPassword(newPassword.text);
                    entryStorage.storeModel(entryListModel);

                    informationDialog.text = "Password successfully changed.";

                }else{
                    informationDialog.text = "Failed to set new password!\nOld password was not correct.";
                }
                passwordChangeDialog.close();
                informationDialog.open();
            }
        }
        Button{id: cancelButton; text: "Cancel"; anchors.top: okButton.bottom; anchors.topMargin: 15; anchors.horizontalCenter: parent.horizontalCenter; onClicked: passwordChangeDialog.close(); platformStyle: ButtonStyle{ inverted: true } }
    }
}
