/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1
import com.meego 1.0
import meepasswords 1.0

PageStackWindow {
    id: appWindow
    initialPage: passwordInputPage

    Component.onCompleted: {
        console.debug("Opening storage...")
        entryStorage.openStorage();
    }

    Component.onDestruction: {
        console.debug("Shutting down...");
    }

    ErrorDialog{
        id: errorDialog
    }

    PasswordInputPage{
        id: passwordInputPage

        states: [
            State {
                name: "NewPassword"
                PropertyChanges {target: passwordInputPage;
                    text: qsTr("Please enter a new password. "
                               + "Please keep the password at a safe place. "
                               + "There is no way to recover a lost password.");
                    onClicked: {
                        entryStorage.setPassword(passwordInputPage.password);
                        pageStack.push(mainPage);
                    }
                }
            },
            State {
                name: "EnterPassword"
                PropertyChanges {target: passwordInputPage;
                    text: qsTr("Enter Password:");
                    onClicked: entryStorage.loadAndDecryptData(passwordInputPage.password, entryListModel);
                }
            },
            State {
                name: "WrongPassword"
                PropertyChanges {target: passwordInputPage;
                    text: qsTr("You entered a wrong password. Please reenter Password:");
                    onClicked: entryStorage.loadAndDecryptData(passwordInputPage.password, entryListModel);
                }
            }
        ]
    }

    MainPage{id: mainPage}

    EntryStorage {
        id: entryStorage

        onStorageOpenSuccess: passwordInputPage.state = "EnterPassword"
        onStorageOpenSuccessNewPassword: passwordInputPage.state = "NewPassword"

        onDecryptionFailed: passwordInputPage.state = "WrongPassword"
        onDecryptionSuccess: pageStack.push(mainPage)
        onNewFileOpened: pageStack.push(mainPage)

        onOperationFailed: {
            errorDialog.message = message;
            errorDialog.open();
        }
    }

    EntryListModel {
        id: entryListModel

        onChanged: entryStorage.storeModel(entryListModel)
    }

}
