/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.0

Item {
    id: menu

    anchors.fill: parent

    visible: false

    z: 16

    Rectangle{
        anchors.fill: parent
        color: "black"
        opacity: 0.6
    }

    MouseArea{
        anchors.fill: parent
        onClicked: {
            close();
        }
    }

    Rectangle{
        id: menuBorder
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 10
        width: parent.width
        height: menuArea.height + 40

        color: "lightgray"
        opacity: 1

        Rectangle{
            id: menuArea
            anchors.centerIn: parent
            width: parent.width - 20
            height: 3 * changePassword.height + 40

            color:"white"
            radius: 20
            opacity: 1

            Button{
                id: changePassword
                anchors.bottom: deleteEntry.top
                anchors.horizontalCenter: parent.horizontalCenter
                width: parent.width - 40
                text: "Change Password"
                onClicked: {
                    menu.close();
                    passwordChangeDialog.open();
                }
            }
            Button{
                id: deleteEntry
                anchors.bottom: about.top
                anchors.horizontalCenter: parent.horizontalCenter
                width: parent.width - 40
                text: "Delete Entry"

                onClicked: {
                    var index = entryListView.currentIndex;
                    deleteConfirmationDialog.index = index;
                    deleteConfirmationDialog.text = "Delete entry \"" + entryListModel.at(index).name +"\"?";
                    deleteConfirmationDialog.open();
                    menu.close();
                }
            }
            Button{
                id: about
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 20
                anchors.horizontalCenter: parent.horizontalCenter
                width: parent.width - 40
                text: "About"
                onClicked: {
                    aboutDialog.open()
                    menu.close();
                }
            }
        }
    }

    function close(){
        menu.visible = false;
    }

    function open(){
        deleteEntry.enabled = entryListView.currentIndex >= 0 && entryListView.currentIndex < entryListModel.rowCount();
        menu.visible = true;
    }
}
