/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef MEEGO_EDITION_HARMATTAN
#include <aegis_crypto.h>
#include <applauncherd/MDeclarativeCache>
#else
#include <QDebug>
#endif

#include <QtCore/QtGlobal>
#include <QtDeclarative>

#include "entry.h"
#include "entrylistmodel.h"
#include "entrystorage.h"

//#include "mcomboboxqmladapter.h"
//#include "mtexteditqmladapter.h"
#include "qcomboboxqmladapter.h"
//#include "qlineeditqmladapter.h"

Q_DECL_EXPORT int main(int argc, char *argv[])
{
//    MApplication app(argc, argv);

#ifdef MEEGO_EDITION_HARMATTAN
    QApplication *app = MDeclarativeCache::qApplication(argc, argv);
    QDeclarativeView *view = MDeclarativeCache::qDeclarativeView();

    char *app_id;
    aegis_application_id(getpid(), &app_id);
    qDebug("Application Id: %s", app_id);
#else
    QApplication *app = new QApplication(argc, argv);
    QDeclarativeView *view = new QDeclarativeView();

    qDebug() << "Qt Build Key: " << QLibraryInfo::buildKey() << "   Qt Build Date: " << QLibraryInfo::buildDate();
#endif

    qmlRegisterType<Entry>("meepasswords", 1, 0, "Entry");
    qmlRegisterType<EntryListModel>("meepasswords", 1, 0, "EntryListModel");
    qmlRegisterType<EntryStorage>("meepasswords", 1, 0, "EntryStorage");

//    qmlRegisterType<MComboBoxQmlAdapter>("meepasswords", 1, 0, "MComboBox");
//    qmlRegisterType<MTextEditQmlAdapter>("meepasswords", 1, 0, "MTextEdit");
    qmlRegisterType<QComboBoxQmlAdapter>("meepasswords", 1, 0, "QComboBox");
//    qmlRegisterType<QLineEditQmlAdapter>("meepasswords", 1, 0, "QLineEdit");

    view->setWindowTitle("MeePasswords");
#ifdef MEEGO_EDITION_HARMATTAN
    view->setSource(QUrl("qrc:/qml/harmattan/main.qml"));
    view->showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    view->setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view->setSource(QUrl("qrc:/qml/desktop/main.qml"));
    view->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    view->show();
    view->resize(800, 424);
#else
    view->setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view->setSource(QUrl("qrc:/qml/desktop/main.qml"));
    view->resize(600, 800);
    view->show();
#endif

    return app->exec();
}
