/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of MeePasswords.
 *
 *  MeePasswords is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MeePasswords is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MeePasswords.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.0
import meepasswords 1.0

Item{
    id: editEntryDialog
    anchors.fill: parent

    visible: false

    property bool edit: false
    property int index: -1

    property alias text: entryLabel.text
    property alias name: nameInput.text
    property alias category: categoryInput.text
    property alias userName: userNameInput.text
    property alias password: passwordInput.text
    property alias notes: notesInput.text

    signal closed()
    signal opened()

    function close(){
        visible = false;
        closed();
    }

    function open(){
//        categoryInput.setItems(entryListModel);
        acceptButton.enabled = edit;
        nameInput.forceActiveFocus();
        visible = true;
        opened();
    }

    MessageDialog{
        id: noNameGivenDialog
        parent: mainPage
        text: "Please enter at least an entry name."

        onRejected: {
            acceptButton.enabled = false;
            nameInput.forceActiveFocus();
        }
    }

    Rectangle {
        id: buttonBar
        anchors.top: parent.top
        height: rejectButton.height + 6
        width: parent.width

        color: "lightgray"

        Button{
            id: rejectButton
            anchors.left: parent.left
            anchors.leftMargin: 16
            anchors.verticalCenter: parent.verticalCenter
            text: "Cancel"
            onClicked: editEntryDialog.close();
        }

        Text {id: entryLabel; text: "Entry"; font.pixelSize: 30; font.capitalization: Font.SmallCaps; font.bold: true; anchors.centerIn: parent}

        Button{
            id: acceptButton
            anchors.right: parent.right
            anchors.rightMargin: 16
            anchors.verticalCenter: parent.verticalCenter
            text: "OK"
            onClicked: {
                if(nameInput.text === ""){
                    noNameGivenDialog.open();
                }else{
                    /*
                     * Hack to get a usable category even when categoryInput is still focused.
                     * categoryInput needs to loose focus at least once in order to return a usable QString.
                     */
                    nameInput.focus = true;
                    if(edit){
                        entryListModel.updateEntryAt(index, nameInput.text, categoryInput.text, userNameInput.text, passwordInput.text, notesInput.text);
                    }else{
                        entryListModel.addEntry(nameInput.text, categoryInput.text, userNameInput.text, passwordInput.text, notesInput.text);
                    }
                    editEntryDialog.close();
                }
            }
        }
    }

     Rectangle {
            anchors.top: buttonBar.bottom
            anchors.bottom: parent.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            width: parent.width - 20

            color: "white"

            Grid{
                id: grid
                z: 2

                anchors.top: parent.top
                anchors.topMargin: 10
                anchors.horizontalCenter: parent.horizontalCenter

                width: parent.width
                columns: 2
                spacing: 5

                Text {text: "Name"}
                Text {text: "Category"}
                TextField{id: nameInput; width: 0.5 * parent.width;
                    onTextChanged: acceptButton.enabled = true
                }

                TextField{id: categoryInput; width: 0.5 * parent.width}

                /*
                QComboBox{id: categoryInput; width: 0.5 * parent.width; z: 3;
                    TextInput{
                        id: textInput
                    }

                    onFocusIn: {
                        textInput.openSoftwareInputPanel();
                    }
                    onFocusOut: {
                        textInput.closeSoftwareInputPanel();
                    }
                }
                */
/*
                MTextEdit{id: categoryInput; width: 0.5 * parent.width;
                    TextInput{
                        id: textInput
                    }

                    MouseArea{
                        anchors.fill: parent;
                        width: categoryInput.width;
                        height: categoryInput.height;
                        onClicked: {
                            categoryInput.focus();
                            textInput.openSoftwareInputPanel();
                        }
                    }
                }
*/

                Text {text: "User Name"}
                Text {text: "Password"}
                TextField{id: userNameInput; width: 0.5 * parent.width}
                TextField{id: passwordInput; width: 0.5 * parent.width}
            }

            Text {id: notesLabel; text: "Notes"; anchors.horizontalCenter: parent.horizontalCenter; anchors.top: grid.bottom; z: 1}
            TextField{id: notesInput; anchors.horizontalCenter: parent.horizontalCenter; anchors.top: notesLabel.bottom; width: parent.width; z: 1}
    }

}
