/*
 *  media player widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MEDIA_PLAYER_WIDGET_WIDGET_H_
#define _MEDIA_PLAYER_WIDGET_WIDGET_H_

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _MediaPlayerWidgetHomePlugin MediaPlayerWidgetHomePlugin;
typedef struct _MediaPlayerWidgetHomePluginClass MediaPlayerWidgetHomePluginClass;

#define MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN (media_player_widget_home_plugin_get_type())
#define MEDIA_PLAYER_WIDGET_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN, MediaPlayerWidgetHomePlugin))
#define MEDIA_PLAYER_WIDGET_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN, MediaPlayerWidgetHomePluginClass))
#define MEDIA_PLAYER_WIDGET_IS_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN))
#define MEDIA_PLAYER_WIDGET_IS_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN))
#define MEDIA_PLAYER_WIDGET_HOME_PLUGIN_GET_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS ((obj), MEDIA_PLAYER_WIDGET_TYPE_HOME_PLUGIN, MediaPlayerWidgetHomePlugin))

typedef struct _MediaPlayerWidgetHomePluginPrivate MediaPlayerWidgetHomePluginPrivate;

struct _MediaPlayerWidgetHomePlugin
{
  HDHomePluginItem hitem;
  MediaPlayerWidgetHomePluginPrivate* priv;
};

struct _MediaPlayerWidgetHomePluginClass
{
  HDHomePluginItemClass parent_class;
};

GType media_player_widget_home_plugin_get_type(void);

G_END_DECLS

#endif
