#!/usr/bin/env python2.5


class mceparser:
    def __init__(self):
        self.filename = '/etc/mce/mce.ini' 
        #self.filename = 'mce.ini' 
        self.fp = open(self.filename, 'r')
        # Don't remove last instance of these patterns
        self.stock_pattern_names = [
            'PatternError',
            'PatternDeviceOn',
            'PatternPowerOn',
            'PatternPowerOff',
            'PatternCommunicationCall',
            'PatternCommunicationIM',
            'PatternCommunicationSMS',
            'PatternCommunicationEmail',
            'PatternCommonNotification',
            'PatternWebcamActive',
            'PatternBatteryCharging',
            'PatternBatteryFull',
            'PatternDeviceSoftOff',
        ]

    def check_pattern(self, pattern):
        import re
        valid_pattern = re.compile('^[0-9]{1,3};[0-5];[0-9]{1,2};[rgb][RGB]?;9d80[0-9a-f]{4,60};9d80[0-9a-f]{4,60}$');
        if valid_pattern.search(pattern):
            return True
        return False

    def add(self, pattern_name, pattern):
        if (self.check_pattern(pattern) != True):
            raise Exception("Given pattern is not validly formatted")
        import datetime
        # Read the file to list
        file_changed = False
        write_lines = []
        for line in self.fp.readlines():
            write_lines.append(line)
        self.fp.close()
        # Then go trough the list and manipulate as neccessary
        section_open = False
        i = 0
        pattern_found = False
        for line in write_lines:
            try:
                # Check if the line is opening of a section we're interested in
                if line[0:5] == '[LED]':
                    section_open = 'led'
                elif line[0:21] == '[LEDPatternLystiRX51]':
                    section_open = 'pattern'
                elif line[0:1] == '[':
                    section_open = False

#                print "section_open=" + repr(section_open)

                # Then check for the LEDPatterns
                if (    section_open == 'led'
                    and line[0:12] == 'LEDPatterns='):
                    enabled_patterns = line[12:-1].split(';')
                    if pattern_name not in enabled_patterns:
                        enabled_patterns.append(pattern_name)
                        new_line = line[0:12] + ';'.join(map(str, enabled_patterns)) + "\n"
                        write_lines[i] = new_line
                        file_changed = True
                
                # Existing (not commented out pattern)
                if (    section_open == 'pattern'
                    and line[0:len(pattern_name)+1] == pattern_name + '='):
                    # This is a bit sneaky since we're actually inserting many lines...
                    new_line = "# Commented out on " + datetime.datetime.now().ctime() + " by mce_ledpattern.py\n#" + line
                    new_line = new_line + "# Added on " + datetime.datetime.now().ctime() + " by mce_ledpattern.py\n"
                    new_line = new_line + pattern_name + "=" + pattern + "\n"
                    pattern_found = True
                    write_lines[i] = new_line
                    file_changed = True
#                    print new_line

                # Pattern not found and reaching end of section
                if (    section_open == 'pattern'
                    and write_lines[i+1][0:1] == '['
                    and not pattern_found):
                    new_line = "# Added on " + datetime.datetime.now().ctime() + " by mce_ledpattern.py\n"
                    new_line = new_line + pattern_name + "=" + pattern + "\n"
                    pattern_found = True
                    write_lines.insert(i, new_line)
                    i = i+1
                    file_changed = True
#                    print new_line

            # We'll be causing a bunch of indexerrors, ignore them
            except IndexError:
                pass

            i = i+1
        
        if file_changed:
            self.atomic_write(write_lines)
            pass


    def remove(self, pattern_name):
        # Read the file to list
        file_changed = False
        write_lines = []
        for line in self.fp.readlines():
            write_lines.append(line)
        self.fp.close()
        # Then go trough the list and manipulate as neccessary
        section_open = False
        i = 0
        pattern_found = False
        # tuple
        active_pattern_lines = None
        # list of tuples
        commented_pattern_lines = []
        for line in write_lines:
            try:
                # Check if the line is opening of a section we're interested in
                if line[0:5] == '[LED]':
                    section_open = 'led'
                elif line[0:21] == '[LEDPatternLystiRX51]':
                    section_open = 'pattern'
                elif line[0:1] == '[':
                    section_open = False

                # Then check for the LEDPatterns
                if (    section_open == 'led'
                    and line[0:12] == 'LEDPatterns='):
                    enabled_patterns_line = i
                    enabled_patterns = line[12:-1].split(';')
                    if pattern_name not in enabled_patterns:
                        raise Exception("Cannot remove pattern that is not enabled in LEDPatterns")

                # Existing (not commented out pattern)
                if (    section_open == 'pattern'
                    and line[0:len(pattern_name)+1] == pattern_name + '='):
                    pattern_found = True
                    if (    write_lines[i-1][0:10] == '# Added on'
                        and write_lines[i-1][-22:] == " by mce_ledpattern.py\n"):
                        active_pattern_lines = (i-1, i)
                    else:
                        active_pattern_lines = (i,)

                # Existing (commented out pattern)
                if (    section_open == 'pattern'
                    and line[0:len(pattern_name)+2] == '#' + pattern_name + '='):
                    if (    write_lines[i-1][0:18] == '# Commented out on'
                        and write_lines[i-1][-22:] == " by mce_ledpattern.py\n"):
                        commented_pattern_lines.append((i-1, i))
                    else:
                        commented_pattern_lines.append((i, ))

                # Pattern not found and reaching end of section
                if (    section_open == 'pattern'
                    and write_lines[i+1][0:1] == '['
                    and not pattern_found):
                        raise Exception("Pattern was in LEDPatterns but not found in LEDPatternLystiRX51-section, something is messed up!")

            # We'll be causing a bunch of indexerrors, ignore them
            except IndexError:
                pass

            i = i+1

        # Check that we're not removing last instance of a stock pattern
        if (    len(commented_pattern_lines) == 0
            and  pattern_name in self.stock_pattern_names):
            raise Exception("Refusing to remove last instance of a stock pattern")

        # Removing last instance of non-stock pattern, remove from LEDPatterns too
        if (    len(commented_pattern_lines) == 0
            and pattern_name in enabled_patterns
            and pattern_name not in self.stock_pattern_names):
                enabled_patterns.remove(pattern_name)
                new_line = write_lines[enabled_patterns_line][0:12] + ';'.join(map(str, enabled_patterns)) + "\n"
                write_lines[enabled_patterns_line] = new_line
                file_changed = True

        # Remove the lines for the active pattern
        for linenum in active_pattern_lines:
            write_lines[linenum] = '' # removing the key changes index numbers, overwrite to empty string instead
            file_changed = True

        # If we have commented out patterns re-enable the latest (in terms of line numbers, we do not parse the timestamp in comments)
        try:
            previous_active = commented_pattern_lines.pop()
            for linenum in previous_active:
                if (write_lines[linenum][0:len(pattern_name)+2] == '#' + pattern_name + '='):
                    write_lines[linenum] = write_lines[linenum][1:]
                    file_changed = True
                else:
                    write_lines[linenum] = '' # removing the key changes index numbers, overwrite to empty string instead
                    file_changed = True
        except IndexError:
            pass

        if file_changed:
            self.atomic_write(write_lines)
            pass

    def atomic_write(self, lines):
        import os
        # Write new lines to file
        self.fp = open(self.filename + '.new', 'w')
        self.fp.writelines(lines)
        self.fp.close()
        os.rename(self.filename + '.new', self.filename)

def cli_usage():
    print "Usage:"
    print "  mce_ledpattern add <pattern_name> \"<pattern>\""
    print "  mce_ledpattern remove <pattern_name>"
    print " "
    print "  To replace existing pattern use add, to restore replaced\n  pattern back to previous value use remove"

def cli():
    try:
        method = sys.argv[1]
        pattern_name = sys.argv[2]
    except IndexError:
        cli_usage()
        return 1
    if method == 'add':
        try:
            pattern = sys.argv[3]
        except IndexError:
            cli_usage()
            return 1
    parser = mceparser()
    if method == 'add':
        parser.add(pattern_name, pattern)
    elif method == 'remove':
        parser.remove(pattern_name)
    else:
        cli_usage()
        return 1
    return 0

if __name__ == '__main__':
    import sys
    sys.exit(cli())