//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef COMMON_H
#define COMMON_H

#define DEBUGINFO QString(__FUNCTION__) + QString("():")

// Definitions

#define DEVICE_UNKNOWN  -1
#define DEVICE_770  0
#define DEVICE_N800  1
#define DEVICE_N810  2
#define DEVICE_N900  3

#define BARCODE_TYPE_NONE     0
#define BARCODE_TYPE_1D       1
#define BARCODE_TYPE_DMTX     2
#define BARCODE_TYPE_QRCODE   3
#define BARCODE_TYPE_PDF417   4

#define MAX_VIDEO_WIDTH   800
#define MAX_VIDEO_HEIGHT  480

#define WIDTH   400
#define HEIGHT  240

#define N900_WIDTH  400
#define N900_HEIGHT 240

#define PAINTGL_INTERVAL_LOW    500
#define PAINTGL_INTERVAL_HIGH   10

#define NO_OF_COLUMNS       4
#define SETTINGS_VERSION    2

#define SCAN_HISTORY_LENGTH 10

#define TYPE_DMTX "dmtx"

// DBus addresses
#define DBUS_SHUTTER_STATE "/org/freedesktop/Hal/devices/platform_cam_shutter"
#define DBUS_FOCUS_BUTTON "/org/freedesktop/Hal/devices/platform_cam_focus"
#define DBUS_RELEASE_BUTTON "/org/freedesktop/Hal/devices/platform_cam_launch"

// Default settings

#define CONTINUOUS_SCANNING_DEFAULT true

#endif // COMMON_H
