//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QPluginLoader>
#include <QDir>
#include <QtGui>
#include <QSettings>
#include <QHash>
#include <QTimer>

//#include <dbus/dbus.h>
#include <QtDBus>

class PluginAction;
class ResultsWindow;
class BarcodeDetector;
class VideoWidget;
class PluginInterface;
class RecentDialog;
class PluginLoaderThread;

struct Property // Dbus property
{
        QString name;
        bool added;
        bool removed;
};
Q_DECLARE_METATYPE(Property)
Q_DECLARE_METATYPE(QList<Property>)

const QDBusArgument & operator<<(QDBusArgument &arg, const Property &change);
const QDBusArgument & operator>>(const QDBusArgument &arg, Property &change);

class MaemoBarcodeWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.mbarcode")

public:
    MaemoBarcodeWindow(QWidget *parent = 0);
    ~MaemoBarcodeWindow();

    BarcodeDetector *decoder;
    VideoWidget *videoWidget;
    ResultsWindow* resultsWindow;

    void startScan();
    bool isLensCoverOpen();
    void sendBarcodeAnalysedSignal(QString barcodeType, QString barcodeData);

    QSettings *settings;


    bool pluginsLoaded;
    QStringList pluginFileNames;
    QList<PluginInterface*> pluginInterfaces;
    QList<PluginAction*> pluginActions;

    //DBusConnection* conn;

    bool continuousScanningMode;
    bool AutoUseFirstPlugin;

    QList<QString> pluginNames;
    QList<unsigned char> pluginPriorities;
    QList<bool> pluginEnabled;

    int NumEnabledPlugins;

signals:
    Q_SCRIPTABLE void barcodeAnalysedSignal(QString barcodeType, QString barcodeData);
    void dataAnalysedSignal(QString dataType, QString barcodeData, QHash<QString, QString> data);
public slots:
    void imageAnalysed(QString barcodeType, QString barcodeData, QImage *image);
    void dataAnalysed(QString dataType, QString barcodeData, QHash<QString, QString> data);
    void lensCoverPropertyModified(int num_updates, QList<Property> updates);
    void focusButtonPropertyModified(int num_updates, QList<Property> updates);
    void cameraButtonPropertyModified(int num_updates, QList<Property> updates);
    void showRecentDialog();
    void showResultsWindow(QString barcode);
    void showSettingsWindow();
    void OpenAndScanImage();
    void analyseImageSyncCallBack();

    //Q_SCRIPTABLE int register_external_plugin(QString appname, QString dbus_command_to_call, QString RequiredBarcodeTypes);
protected:
    void changeEvent(QEvent *e);

    RecentDialog* getRecentDialog();
    void ensurePluginsLoaded();

private:


    void loadPlugins();
    RecentDialog *recentDialog;


    void initLensCoverState();

    bool focusing;
    bool firstChangeEvent; // used to avoid starting and stopping the videoWidget when launching the application
    bool secondChangeEvent;
    bool lensCoverOpen;

    uchar* imageBuffer;


    //PluginLoaderThread *pluginloaderthread;

private slots:
//    void on_actionTest_portrait_mode_triggered();
//    void on_actionPlugins_triggered();

//    void on_btnCancel_clicked();
//    void on_btnRefocus_clicked();
//    void on_btnScan_clicked();
    void setFocusing(bool enabled);
    void saveBufferImage();

    void keyPressEvent(QKeyEvent*);
//    void RestartContinuousScanning();
    //
};

#endif // MAINWINDOW_H
