#ifndef PLUGINSETTINGS_H
#define PLUGINSETTINGS_H

#include <QMainWindow>
#include <QtGui>

namespace Ui {
    class PluginSettings;
}
class PluginInterface;
class PluginAction;

class PluginSettings : public QMainWindow {
    Q_OBJECT
public:
    PluginSettings(QList<PluginAction*> pluginActions, QWidget *parent = 0);
    ~PluginSettings();

    QStandardItemModel *model;
    QHash<int, PluginInterface*> idToInterface;
    QHash<int, PluginAction*> idToAction;
    //QHash<int, int> idToPluginArrays;

protected:
    void changeEvent(QEvent *e);
    void hideEvent(QHideEvent *);
    void showEvent(QShowEvent *);

private:
    Ui::PluginSettings *ui;
    QModelIndex oldIndex;

private slots:
    void on_tblPlugins_doubleClicked(QModelIndex index);
    void on_btnReducePriority_clicked();
    void on_btnIncreasePriority_clicked();
    void on_tblPlugins_clicked(QModelIndex index);
};

#endif // PLUGINSETTINGS_H
