#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "maemobarcodewindow.h"
#include "videowidget.h"
#include "barcodedetector.h"
#include "pluginsettings.h"
#include "plugininterfaces.h"
#include <QDebug>

SettingsWindow::SettingsWindow(MaemoBarcodeWindow *parent) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    this->parent = parent;
    this->settings = parent->settings;
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::hideEvent(QHideEvent *) {
    settings->setValue("save_history", ui->chkSaveHistory->isChecked());
    settings->setValue("use_autofocus", ui->chkAutofocus->isChecked());
    settings->setValue("use_full_screen", ui->chkFullScreen->isChecked());
    settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
    settings->setValue("continous_scanning", ui->radioButtonContinuousScanning->isChecked());
    settings->setValue("auto_use_first_plugin", ui->chkUseFirstPlugin->isChecked());
    if(ui->chkFullScreen->isChecked()) {
        parent->showFullScreen();
    } else {
        parent->showNormal();
    }
    if(ui->chkAutofocus->isChecked()) {
        parent->videoWidget->refocusTimer->start();
    } else {
        parent->videoWidget->refocusTimer->stop();
    }

    if (ui->radioButtonContinuousScanning->isChecked()){
        parent->continuousScanningMode = true;
        parent->videoWidget->setContinuousScanning(true);
    }else{
        parent->continuousScanningMode = false;
        parent->videoWidget->setContinuousScanning(false);
    }

    if (ui->chkUseFirstPlugin->isChecked()){
        parent->AutoUseFirstPlugin = true;
    }else{
        parent->AutoUseFirstPlugin = false;
    }

//    settings->sync(); // Not necessary to call, it is called automatically.



    // save some settings

    // get rid of any old entries first
    settings->remove("plugins");

    // debugging code over the next 3 lines
    int num = settings->beginReadArray("plugins");
    settings->endArray();
    qDebug() << "~MaemoBarcodeWindow(): Removing old entries. Remaining=" << num;
    // end debugging code


    //parent->NumEnabledPlugins=0;

    settings->beginWriteArray("plugins");
    for (int i=0; i<parent->pluginActions.size(); ++i){
        settings->setArrayIndex(i);

        PluginAction *action = parent->pluginActions.at(i);
        PluginInterface *interface = const_cast<PluginInterface*>(action->getInterface());

        qDebug() << "~MaemoBarcodeWindow(): Saving plugin " <<  interface->getName() + ": " + action->getName() << " " << action->getPriority() << " " << action->getEnabled();

        settings->setValue("pluginName", interface->getName() + ": " + action->getName());
        settings->setValue("pluginPriority", action->getPriority());
        settings->setValue("pluginEnabled", action->getEnabled());

        //if (action->getEnabled())
        //    parent->NumEnabledPlugins++;
    }
    settings->endArray();



}

void SettingsWindow::showEvent(QShowEvent *) {
    qDebug() << "SettingsWindow::SettingsWindow(): Setting initial settings";
    ui->chkSaveHistory->setChecked(settings->value("save_history", true).toBool());
    ui->chkAutofocus->setChecked(settings->value("use_autofocus", true).toBool());
    ui->chkFullScreen->setChecked(settings->value("use_full_screen", true).toBool());
    ui->spnAutoFocusDelay->setValue(settings->value("autofocus_delay", 2.0).toDouble());
    ui->radioButtonContinuousScanning->setChecked(settings->value("continous_scanning", CONTINUOUS_SCANNING_DEFAULT).toBool());
    ui->radioButtonPressToScan->setChecked(!settings->value("continous_scanning", CONTINUOUS_SCANNING_DEFAULT).toBool());
    ui->chkUseFirstPlugin->setChecked(settings->value("auto_use_first_plugin", false).toBool());
}

void SettingsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsWindow::on_chkSaveHistory_clicked()
{
    //settings->setValue("save_history", ui->chkSaveHistory->isChecked());
}

void SettingsWindow::on_spnAutoFocusDelay_valueChanged(double value)
{
    //settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
}

// this is done automatically for us :)
void SettingsWindow::on_radioButtonContinuousScanning_clicked()
{
    //ui->radioButtonPressToScan->setChecked(false);
}

void SettingsWindow::on_radioButtonPressToScan_clicked()
{
    //ui->radioButtonContinuousScanning->setChecked(false);
}



void SettingsWindow::on_btnPluginSettings_clicked()
{
    //parent->ensurePluginsLoaded(); // not allowed, protected fn
    PluginSettings* win = new PluginSettings(parent->pluginActions,  this);
    win->show();
}
