#ifndef PLUGININTERMEDIATE_H
#define PLUGININTERMEDIATE_H

#include <QtGui>

/*
  This is an intermediate class between a sinkplugin and our interface.
  Since the Qt Plugin framework does not let us define slots in our
  plugins, this class is used as a work around to that.

  For instance, when a plugin button is clicked, the slot in this class
  is called, which in turn calls the plugins class.
*/

class PluginAction;

class PluginIntermediate : public QObject
{
    Q_OBJECT
public:
    PluginIntermediate(PluginAction *plugin, QWidget *parentWindow);
public slots:
    void clickedPlugin();
private:
    PluginAction *plugin;
    QWidget *parentWindow;
};

#endif // PLUGININTERMEDIATE_H
