//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.


#ifndef BARCODEDETECTOR_H
#define BARCODEDETECTOR_H

//qt includes
#include <QObject>
//gstreamer includes
#include <gst/gst.h>
#include <gst/gstbin.h>
#include <gst/interfaces/xoverlay.h>
#include <gst/interfaces/photography.h>
// other includes
#include <stdio.h>
#include <zbar.h>
// local includes
#include "common.h"
#include "dmtxdecoderthread.h"
#include "zbardecoderthread.h"
#include <QWaitCondition>
#include <QImage>
#include <QTimer>
#include <qmutex.h>

#define DMTX_RUN_INTERVAL 1

class VideoWidget;
class DBusConnection;
using namespace zbar;

class BarcodeDetector : public QObject {
    Q_OBJECT;
public:
    BarcodeDetector();
    ~BarcodeDetector();

    // from decoder.c
    // TEMPORARILY made static!
    int analyseImageSync(char *buffer, int frame_width, int frame_height, char *fourcc, int bpp, int mstimeout, const QObject * receiver, char const* slot_method);
    int analyseImage(char *buffer, int width, int height, char *fourcc, int bpp);
    QImage* getLastImage();
    //void setFrameSize(int frameWidth, int frameHeight);

    bool scanning_status;

    //int frame_width;
    //int frame_height;

    int getAnalysedImageResult();

signals:
    void imageAnalysed(QString imageType, QString imageData, QImage *image);
private:


    // from decoder.c
    // TODO: Clean up
    char globalEAN[14];

    clock_t QR1D_timer;
    clock_t dmtx_timer;

    // from appdata.h
    // TODO: Clean up uneeded variables
    GstElement *camera_src;
    gboolean isportrait;
    gboolean accelerometers;
    DBusConnection *con;
    GstElement *pipeline;
    guint buffer_cb_id;
    guint timer_id;
    long long last_upc_value;
    int scan_in_progress;
    gchar current_data_table_name[255];
    int deviceType;


    QTimer imgAnalysisSyncTimer;

    DMTXDecoderThread dmtx_thread;
    ZBarDecoderThread zbar_thread;


};

#endif // BARCODEDETECTOR_H
