//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef RESULTSWINDOW_H
#define RESULTSWINDOW_H

// qt includes
#include <QtGui>
#include <QTimer>
// local includes

class PluginAction;

namespace Ui {
    class ResultsWindow;
}
class PluginActionListModel : public QAbstractListModel {
    Q_OBJECT
public:
    PluginActionListModel(QObject *parent = 0, QList<PluginAction *>list = QList<PluginAction *>())
        : QAbstractListModel(parent) {
        plugin_list = list;
    }
    int rowCount(const QModelIndex &model = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
public slots:

private:
    QList<PluginAction *> plugin_list;
};
class PluginActionListDelegate : public QStyledItemDelegate {
Q_OBJECT

public:
PluginActionListDelegate(QObject *parent = 0)
    : QStyledItemDelegate(parent) {}

void paint(QPainter *painter, const QStyleOptionViewItem &option,
           const QModelIndex &index) const;
QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index);
};
class ResultsWindow : public QMainWindow {
    Q_OBJECT
public:
    ResultsWindow(QWidget *parent = 0);
    ~ResultsWindow();

    void processBarcode(QString barcode);
    void setPluginActions(QList<PluginAction*> plugins);

protected:
    void changeEvent(QEvent *e);

private:
    QList<PluginAction*> plugins;
    QList<PluginAction*> addedPlugins;

    Ui::ResultsWindow *ui;
    QTimer *checkTimer;

    QString barcode_text;

    QTimer *selectionTimer;

    int PluginUpdateCounter;

private slots:
    void on_tblResults_clicked(QModelIndex index);
    void on_pushButton_clicked();
    void checkPlugins(); // called by a timer to see if there are any plugins which are ready
    void selectionTimerExpiry();
};

#endif // RESULTSWINDOW_H
