#include "pluginloaderthread.h"
#include "plugininterfaces.h"
#include "pluginaction.h"
#include "maemobarcodewindow.h"
#include "resultswindow.h"

PluginLoaderThread::PluginLoaderThread(MaemoBarcodeWindow *resultsWindow)
{
    this->w = resultsWindow;
}


void PluginLoaderThread::run()
{
    // TODO: Create a system which lets the user enable/disable plugins. These should not be loaded.

    qDebug("Loading plugins...");

    //    pluginsDir = QDir(qApp->applicationDirPath());.
    QDir pluginsDir = QDir("/usr/share/mbarcode/");
    QDir pluginsDirHome = QDir(QDir::homePath() + "/.config/mbarcode/plugins");

    // some path stuff derived from Nokia's plugin tutorials - not really necessary in a Maemo app, but we'll just leave them here
#if defined(Q_OS_WIN)
    if (pluginsDir.dirName().toLower() == "debug" || pluginsDir.dirName().toLower() == "release")
        pluginsDir.cdUp();
#elif defined(Q_OS_MAC)
    if (pluginsDir.dirName() == "MacOS") {
        pluginsDir.cdUp();
        pluginsDir.cdUp();
        pluginsDir.cdUp();
    }
#endif
    pluginsDir.cd("plugins");
    QStringList allPluginFiles;

    foreach (QString fileName, pluginsDir.entryList(QDir::Files)) { // go through all files in the plugin dir
        allPluginFiles << pluginsDir.absoluteFilePath(fileName);
    }
    foreach (QString fileName, pluginsDirHome.entryList(QDir::Files)) { // go through all files in the plugin dir in home
        allPluginFiles << pluginsDirHome.absoluteFilePath(fileName);
    }
    foreach (QString fileName, allPluginFiles) { // go through all files in the plugin dir
        qDebug(qPrintable("Loading " + fileName));
        QPluginLoader loader(fileName); // create a loader for the shared library
        QObject *plugin = loader.instance();  // load it as a QObject
        if (plugin) { // if it is a plugin (this fails if virtual functions are not implemented correct)
            qDebug(qPrintable("Loaded successfully: " + fileName));
            w->pluginFileNames += fileName; // list all our plugin file names
            PluginInterface* interface = qobject_cast<PluginInterface*>(plugin); // cast it to our kind of interface
            qDebug(qPrintable("Interface name: " + interface->getName()));
            w->pluginInterfaces.append(interface); // add this interface to our list of interfaces
            interface->initInterface(w); // initialize the plugin
            foreach(PluginAction* pluginAction, interface->getPluginActions()) { // get the list of sink plugins in the interface
                qDebug(qPrintable("Loading sink plugin " + pluginAction->getName()));
                w->pluginActions.append(pluginAction); // add them to our list
            }
        } else {
            qWarning(qPrintable("Could not load: " + fileName));
        }
    }
    qDebug("Done loading plugins");
    w->resultsWindow->setPluginActions(w->pluginActions); // let the resultwindow have all our plugins
    w->pluginsLoaded = true;

}
