//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.


// gstreamer includes
#include <gst/gst.h>
#include <gst/gstbin.h>
#include <gst/interfaces/xoverlay.h>
#include <gst/interfaces/photography.h>
// qt includes
#include <QWidget>
#include <QApplication>
// other includes
#include <dmtx.h>
#include <zbar.h>
// local includes
#include "common.h"
#include "barcodedetector.h"
#include "dmtxdecoderthread.h"
#include "zbardecoderthread.h"
#include <QWaitCondition>
#include <qmutex.h>
#include <QDebug>

using namespace zbar;

BarcodeDetector* barcodeDetector_callback; // makes it possible to callback to member functions.
                                            // This pointer needs to be set to the correct object before calling any member functions!

BarcodeDetector::BarcodeDetector() {
//    frame_width = 320;
//    frame_height = 240;
    qDebug("Init BarcodeDetector");
    // init from maemo-barcode.c



    scanning_status = false;
    this->dmtx_timer = clock(); // set initial clock time

    qDebug("Ended init BarcodeDetector");
}

BarcodeDetector::~BarcodeDetector() {

    // shut down the pipeline if needed

    // kill the thread


}

int BarcodeDetector::analyseImage(char *buffer, char *fourcc, int bpp) {
    // stop this code running as it's segfaulting atm
    if (!this->dmtx_thread.isRunning())
        dmtx_thread.start();
    else if(!this->dmtx_thread.isDecoding) {

        // check and see if it has decoded something
        if(this->dmtx_thread.hasFoundBarcode){
            qDebug() << "analyse_image(): found datamatrix";
            // it has decoded something)
            //strcpy(*output, thread_output); // make output a pointer to the thread shared output buffer
            //*output = this->dmtx_thread.thread_output;

            this->dmtx_thread.hasFoundBarcode = false; // reset this so we don't look at this data again

            const uchar *buffer = (uchar *)this->dmtx_thread.thread_buffer;
            unsigned int height = this->dmtx_thread.frame_height;
            unsigned int width = this->dmtx_thread.frame_width;
            QImage::Format format = QImage::Format_Indexed8; // we can't always assume this.....
            QImage *qi = new QImage(width, height, format); //(buffer, width, height, width, format);
            // generate a colourmap
            qi->setNumColors(256);
            for(int i=0;i<256;i++){
                qi->setColor(i,QColor(i,i,i,255).rgba());
            }
            qi->fill(0);
            for(unsigned int i=0;i<width;i++){
                for(unsigned int j=0;j<height;j++){
                    qi->setPixel(i,j,buffer[i+j*width]);
                }
            }

            emit imageAnalysed(TYPE_DMTX,
                               QString::fromUtf8(this->dmtx_thread.thread_output),
                               qi); // *output

            return ZBAR_QRCODE; // QR is also 2D so achieves the same effect //BARCODE_TYPE_DMTX;

        // thread is not running, check to see whether enough time has elapsed to start it running again...
        } else if(clock()-dmtx_timer>=DMTX_RUN_INTERVAL) {
//            qDebug("analyse_image(): start dmtx thread running");

            // copy the image data to the shared buffer
            memcpy(this->dmtx_thread.thread_buffer, buffer, frame_width*frame_height*sizeof(char)*bpp/24); // should be the right amount of data....
            this->dmtx_thread.frame_width=frame_width;
            this->dmtx_thread.frame_height=frame_height;

            if(strstr((char*)fourcc, "RGB3")){
                if(bpp==16)
                    this->dmtx_thread.frame_fourcc=DmtxPack16bppRGB;
                else if (bpp==24)
                    this->dmtx_thread.frame_fourcc=DmtxPack24bppRGB;
                else if (bpp==32)
                    this->dmtx_thread.frame_fourcc=DmtxPack32bppRGBX;
            }else if (bpp==8)
                this->dmtx_thread.frame_fourcc=DmtxPack8bppK;

//            qDebug("is RGB, %d\n", this->dmtx_thread.frame_fourcc); // DEBUG

            this->dmtx_thread.thread_run.wakeOne(); // let the thread continue running
            this->dmtx_timer = clock();
//            this->dmtx_thread.isDecoding = true; // set flag that says the thread is running

        }
    }
    // otherwise it must be running, so leave it be

    if(!this->zbar_thread.isRunning()) {

        zbar_thread.start();
    } else if(!this->zbar_thread.isDecoding){
//        qDebug() << "analyse_image() zbar thread is not decoding";

        // check and see if it has decoded something
        if(this->zbar_thread.hasFoundBarcode){
            qDebug() << "analyse_image(): found ZBar barcode, zbar_thread.hasReturned=" << this->zbar_thread.hasFoundBarcode;
            // it has decoded something)
            //strcpy(*output, thread_output); // make output a pointer to the thread shared output buffer
            //*output = this->dmtx_thread.thread_output;

            this->zbar_thread.hasFoundBarcode = false; // reset this so we don't look at this data again

            qDebug() << "analyse_image(): found ZBar barcode, zbar_thread.thread_output=" << QString(this->zbar_thread.thread_output);
            qDebug() << "analyse_image(): found ZBar barcode, zbar_thread.barcode_type=" << QString(this->zbar_thread.barcode_type);

            const uchar *buffer = (uchar *)this->zbar_thread.thread_buffer;
            unsigned int height = this->zbar_thread.frame_height;
            unsigned int width = this->zbar_thread.frame_width;
            QImage::Format format = QImage::Format_RGB888; // we can't always assume this.....
            QImage *qi = new QImage(buffer, width, height, format); //(buffer, width, height, width, format);

            emit imageAnalysed(QString::fromUtf8(this->zbar_thread.barcode_type),
                               QString::fromUtf8(this->zbar_thread.thread_output),
                               qi); // *output

            return 1; // not sure this makes any odds anymore anyway.


        } else { // for the DMTX thread this had a timer, but we want to run as fast as possible so no timer checks
//            qDebug("analyse_image(): no barcode found, start zbar thread running");

            // copy the image data to the shared buffer
            // set to bpp/24 for now, seems to avoid crashes..
            memcpy(this->zbar_thread.thread_buffer, buffer, frame_width*frame_height*sizeof(char)*bpp/8); // should be the right amount of data....

            this->zbar_thread.frame_width=frame_width;
            this->zbar_thread.frame_height=frame_height;

            this->zbar_thread.frame_bpp=bpp;
            memcpy(this->zbar_thread.frame_fourcc, fourcc, 5);


            this->zbar_thread.thread_run.wakeOne(); // let the thread continue running
            //this->zbar_thread.isDecoding = true; // set flag that says the thread is running

        }
    } else {
//        qDebug() << "analyse_image() zbar thread is decoding";
    }


    return 0; // generic, as we're not using the return type anymore, best turn into a void fn eventually




}

void BarcodeDetector::setFrameSize(int frameWidth, int frameHeight) {
    this->frame_width = frameWidth;
    this->frame_height = frameHeight;
    this->zbar_thread.frame_width = frameWidth;
    this->zbar_thread.frame_height = frameHeight;
    this->dmtx_thread.frame_width = frameWidth;
    this->dmtx_thread.frame_height = frameHeight;
}

QImage *BarcodeDetector::getLastImage() {

    // need to change this function so it can return the last attempted decode of either the zbar or dmtx thread
    // should be easy to do.
    // That way we can also allow people to send in images of barcodes that couldn't be decoded... :)

    const uchar *buffer = (uchar *)this->zbar_thread.thread_buffer;
    unsigned int height = this->zbar_thread.frame_height;
    unsigned int width = this->zbar_thread.frame_width;

    // we can't always assume this.....
    QImage::Format format = QImage::Format_RGB888; // should be b/w indexed 8 from zbar

    // we really need to do some conversions, etc. if format is not known
    // but for the time being we'll just assume it's 8bit b&w

    qDebug() << "getLastImage size width=" << width << " height=" << height;

    QImage *qi = new QImage(buffer, width, height, format); //(buffer, width, height, width, format);

    //for(unsigned int i=0;i<height;i++){
    //    memcpy((void*)(qi->scanLine(i)), (const void*)buffer[i*width], (size_t)width);
    //}

    //qi->fromData((const uchar *)buffer, (int)(width*height),"BMP");
    //

    return qi;
}

void BarcodeDetector::start() {
    // start the pipeline and decoding
    //this->scanning_status = true;
    //this->pipeline;

}

void BarcodeDetector::stop()
{
    // stop the pipeline and decoding
//    self->scanning_status = false;
}

void BarcodeDetector::doFocus()
{
    // Autofocus
//    if (self->scanning_status){
//        gst_element_set_state (pipeline, GST_STATE_PAUSED);
//        gst_photography_set_scene_mode (GST_PHOTOGRAPHY (camera_src), GST_PHOTOGRAPHY_SCENE_MODE_CLOSEUP);
//        gst_photography_set_autofocus(GST_PHOTOGRAPHY(camera_src), TRUE);
//        gst_element_set_state (pipeline, GST_STATE_READY);
//       gst_element_set_state (pipeline, GST_STATE_PLAYING);
//    }
}

void BarcodeDetector::loadFromFile()
{
    // load an image from file and feed it to the decoders
}


void BarcodeDetector::dmtxCallback()
{
    // callback for dmtx GStreamer element
}

void BarcodeDetector::zbarCallback()
{
    // callback for ZBar GStreamer element
}
