#ifndef PROVIDERPLUGIN_H
#define PROVIDERPLUGIN_H

#include <QtCore>

class PluginInterface;

// IMPORTANT: For some reason every virtual function must have a const = 0 for the function to be loaded
// If anyone knows why, please tell me (dragly)

class ProviderPlugin : public QObject {
Q_OBJECT
public:
    ProviderPlugin(const PluginInterface *interface) {this->interface = interface;}
    virtual ~ProviderPlugin() {}
    virtual QString getName() const = 0;
    virtual void analyze(QString data, QString type) const = 0;
    const PluginInterface* getInterface() {return this->interface;}
private:
    const PluginInterface* interface;


};

#endif // PROVIDERPLUGIN_H
