#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "mainwindow.h"
#include <QDebug>

SettingsWindow::SettingsWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

SettingsWindow::~SettingsWindow()
{
    settings->setValue("fullscreen_scan", ui->chkFullscreenScan->isChecked());
    settings->setValue("save_history", ui->chkSaveHistory->isChecked());
    settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
    settings->sync();
    delete ui;
}

void SettingsWindow::setSettings(QSettings *settings) {
    this->settings = settings;
    qDebug() << "SettingsWindow::SettingsWindow(): Setting initial settings";
    ui->chkFullscreenScan->setChecked(settings->value("fullscreen_scan", false).toBool());
    ui->chkSaveHistory->setChecked(settings->value("save_history", true).toBool());
    ui->spnAutoFocusDelay->setValue(settings->value("autofocus_delay", 1.5).toDouble());
}

void SettingsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsWindow::on_chkFullscreenScan_clicked()
{
    //settings->setValue("fullscreen_scan", ui->chkFullscreenScan->isChecked());
}

void SettingsWindow::on_chkSaveHistory_clicked()
{
    //settings->setValue("save_history", ui->chkSaveHistory->isChecked());
}

void SettingsWindow::on_spnAutoFocusDelay_valueChanged(double value)
{
    //settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
}
