//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QPluginLoader>
#include <QDir>
#include <QSet>
#include <QtGui>
#include <QSettings>
#include <QHash>

class SinkPlugin;
class ResultsWindow;
class BarcodeDetector;
class VideoWidget;
class PluginInterface;

namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    BarcodeDetector *decoder;
    VideoWidget *videoWidget;
    ResultsWindow* resultsWindow;

    void cancelScan();
    void startScan();

    QSettings *settings;

    QStandardItemModel *tillRollModel;
signals:
    void barcodeAnalysedSignal(QString barcodeType, QString barcodeData);
    void dataAnalysedSignal(QString dataType, QString barcodeData, QHash<QString, QString> data);
public slots:
    void imageAnalysed(QString barcodeType, QString barcodeData);
    void dataAnalysed(QString dataType, QString barcodeData, QHash<QString, QString> data);
private:
    Ui::MainWindow *ui;

    QStringList pluginFileNames;
    QDir pluginsDir;
    QSet<SinkPlugin*> sinkPlugins;
    QSet<PluginInterface*> pluginInterfaces;

    void loadPlugins();
    void showResultsWindow(QString barcode);

    bool focusing;


private slots:
    void on_actionPlugins_triggered();
    void on_tblTillRoll_clicked(QModelIndex index);
    void on_btnOpenImage_clicked();
    void on_actionSettings_triggered();
    void on_btnCancel_clicked();
    void on_btnRefocus_clicked();
    void on_btnScan_clicked();
    void setFocusing(bool enabled);
};

#endif // MAINWINDOW_H
