#include <stdio.h>
#include <sqlite3.h>
#include <glib.h>
#include "upc_local.h"

/*
int main(int argc, char **argv)
{
 upc_data test;
 gchar testupc[] = "0022100001701";
 if (argc > 1)
  get_upc_data(argv[1], &test);
 else
  get_upc_data(testupc, &test);

 if (test.package != NULL) {
  printf("col 0: %s\n",test.upc);
  printf("col 1: %s\n",test.package);
  printf("col 2: %s\n",test.name);
 }

 return 0;
}
*/
void get_upc_data(char * upc_code, upc_data * my_upc_data) {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;
    sqlite3_stmt *stmt;
    GString * command;

    printf("Received request for UPC: %s\n", upc_code);

    command = g_string_new("select * from items where upc=");
    g_string_append(command, upc_code);
    g_string_append(command, ";");

    /*
    if( argc!=3 ){
     fprintf(stderr, "Usage: %s DATABASE SQL-STATEMENT\n", argv[0]);
     exit(1);
    }
    */

    printf("Opening database...\n");
    rc = sqlite3_open("upc3.db", &db);
    if ( rc ) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return;
    } else {
        printf("Preparing statement...\n");
        rc = sqlite3_prepare_v2(db, command->str, command->len, &stmt, NULL);
        printf("Querying database...\n");
        rc = sqlite3_step(stmt);
        if ( rc!=SQLITE_ROW ) {
            fprintf(stderr, "SQL error: %s\n", zErrMsg);
            sqlite3_free(zErrMsg);
            my_upc_data->upc = upc_code;
            my_upc_data->package = "unknown";
            my_upc_data->name = "unknown";
        } else {
            printf("Filling upc_data...\n");
            //my_upc_data->upc = (int *)sqlite3_column_int(stmt, 0);
            my_upc_data->upc = (char *)sqlite3_column_text(stmt,0);
            my_upc_data->package = (char *)sqlite3_column_text(stmt, 1);
            my_upc_data->name = (char *)sqlite3_column_text(stmt, 2);
        }
    }
    sqlite3_finalize(stmt);
    sqlite3_close(db);

    printf("Done with database query...\n");
}
