/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#ifndef MAEMO_BARCODE_H
#define MAEMO_BARCODE_H

#include <gtk/gtk.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
//#include <sqlite3.h>






#define NO_OF_TABS   4

//int main(int argc, char **argv);
void shutdown();


gint dbus_req_handler(const gchar * interface, const gchar * method,
                      GArray * arguments, gpointer data,
                      osso_rpc_t * retval);


/*
void number_to_string(int *number, char *result);
gboolean compare_numbers (int *number1, int *number2);
*/
unsigned char *number_to_string (int *number);
int compare_numbers (int *number1, int *number2);

long long convert_number (int * num);
void notebook_page_change(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void get_device_type();
#endif

