/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>

#include <dbus/dbus.h>          /* Pull in all of D-Bus headers. */

#include "common.h"
#include "batoo.h"
#include "maemo-barcode.h"
#include "lists.h"

#ifdef FREMANTLE
#include "gui_fremantle.h"
#else
#include "gui_diablo.h"
#endif /* N900 */

#ifdef N900
#include "camera_n900.h"
#else
#include "camera_n8x0.h"
#endif /* N900 */

/*
http://www.semapedia.org/
http://en.barcodepedia.com/
*/






/* Initialize the gui by creating a HildonProgram
 * and HildonWindow */


AppData *appdata;



#define NO_OF_TABS   4

int main (int argc, char **argv) {
    AppData appdata_obj;
    GtkWidget *tab[NO_OF_TABS], *label[NO_OF_TABS];
    char current_pretty_name[255];
    int id;
    
    appdata = &appdata_obj;
    
    appdata->lists_store = NULL;
    appdata->data_store = NULL;

    /* Open the database */
    appdata->db = init_db();

    //test_db_is_ok();
    get_device_type();

#ifdef USE_ZBAR
    appdata->scanner = zbar_image_scanner_create();
    /* configure the reader */
    zbar_image_scanner_set_config(appdata->scanner, 0, ZBAR_CFG_ENABLE, 1);
    zbar_image_scanner_enable_cache(appdata->scanner, TRUE);
    appdata->image = zbar_image_create();
#endif

    /* Initialize and create the GUI */
    initialize_gui(&appdata->program, &appdata->window, &argc, &argv, "mBarcode");

    appdata->notebook = gtk_notebook_new();

    // not sure if I need to remember the pointers to these items
    tab[0] = create_scan_window();
    gtk_widget_show_all(tab[0]);
    label[0] = gtk_label_new ("Scan");
    gtk_notebook_append_page(GTK_NOTEBOOK(appdata->notebook), tab[0], label[0]);

// comment this out as it's not working atm
/*
    tab[1] = create_info_window(""); // have to decide whether empty will be NULL or empty char array
    gtk_widget_show_all(tab[1]);
    label[1] = gtk_label_new ("Info");
    gtk_notebook_append_page(GTK_NOTEBOOK(appdata->notebook), tab[1], label[1]);

    tab[2] = create_lists_window();
    gtk_widget_show_all(tab[2]);
    label[2] = gtk_label_new ("Lists");
    gtk_notebook_append_page(GTK_NOTEBOOK(appdata->notebook), tab[2], label[2]);

    // get the first data table from the lists table
    get_first_data_table(&id, appdata->current_data_table_name, current_pretty_name);
    printf("get_first_data_table() returned %s and %s\n", appdata->current_data_table_name, current_pretty_name);

    // feed this name (or empty string) through in appdata->current_data_table_name
    printf("About to create Data window\n");
    tab[3] = create_data_window();
    gtk_widget_show_all(tab[3]);
    label[3] = gtk_label_new ("Data");
    gtk_notebook_append_page(GTK_NOTEBOOK(appdata->notebook), tab[3], label[3]);

    printf("About to create Search window\n");
    tab[4] = create_search_window();
    gtk_widget_show_all(tab[4]);
    label[4] = gtk_label_new ("Search results");
    gtk_notebook_append_page(GTK_NOTEBOOK(appdata->notebook), tab[4], label[4]);
*/
    gtk_container_add (GTK_CONTAINER (appdata->window), appdata->notebook);

    /* Hopefully use this to make sure the overlay is put back in place when we get to the first page of the notebook! */
    g_signal_connect (G_OBJECT (appdata->notebook), "switch-page", G_CALLBACK (notebook_page_change), NULL);


    /* Initialize the Gst pipeline */
    if (!initialize_pipeline (&argc, &argv)) {
        hildon_banner_show_information (GTK_WIDGET (appdata->window), "gtk-dialog-error", "Failed to initialize pipeline");
    }

    g_signal_connect (G_OBJECT (appdata->window), "destroy", G_CALLBACK (shutdown), NULL);

    gtk_widget_show_all (GTK_WIDGET (appdata->window));

    gtk_main ();

    //close_db();
    return 0;
}



void notebook_page_change(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data) {
    printf("notebook_page_change\n");
    // this is not necessary
    /*
    // the notepad page has changed, if it's changed to the scan tab, make sure we re-enable the overlay so we can see the video
    if (page_num==0){ // make sure we change this if something other than the scan window goes in first!!!!
       gtk_widget_queue_draw(appdata->screen); // invalidate the widget which displays the video, so the overlay gets setup again. Hopefully!
       printf("notebook_page_change 0\n");
    }
    */
}



void shutdown(GtkWidget * widget) {
    destroy_pipeline(widget);
    //free(appdata->image_buffer);
    close_db();
    exit(0);
}




unsigned char *number_to_string (int *number)
{
  unsigned char *result = (unsigned char *) malloc (14 * sizeof (char));
  int i;
  for (i = 0; i < 13; i++)
    result[i] = number[i] + 48;
  result[13] = 0;
  return result;
}

int compare_numbers (int *number1, int *number2)
{
  int i;
  for (i = 0; i < 13; i++)
    if (number1[i] != number2[i])
      return FALSE;
  return TRUE;
}

/*
void number_to_string (int *number, char *result) {
    int i;
    //result = malloc(14 * sizeof(char));
    // assume result already exists now
    for (i = 0; i < 13; i++)
        result[i] = number[i] + 48;
    result[13] = 0;
    return;
}


gboolean compare_numbers (int *number1, int *number2) {
    int i;
    for (i = 0; i < 13; i++)
        if (number1[i] != number2[i])
            return FALSE;
    return TRUE;
}
*/

long long convert_number (int * num) {
    int i;
    long long ret = 0;
    for (i = 0; i < 13; i++) {
        ret = ret*10+num[i];
    }

    return ret;
}


void get_device_type() {
    char d[255];
    FILE *f;
    f = fopen("/proc/component_version", "r");
    fgets(d,255,f);
    fclose(f);

    if (strstr(d, "SU-18")) {
        printf("We're a 770\n");
        appdata->device_type = DEVICE_770;
        appdata->frame_height = HEIGHT;
        appdata->frame_width = WIDTH;
    } else if (strstr(d, "RX-34")) {
        printf( "We're an N800\n");
        appdata->device_type = DEVICE_N800;
        appdata->frame_height = HEIGHT;
        appdata->frame_width = WIDTH;
    } else if (strstr(d, "RX-44")) {
        printf( "We're an N810\n");
        appdata->device_type = DEVICE_N810;
        appdata->frame_height = HEIGHT;
        appdata->frame_width = WIDTH;
    } else if (strstr(d, "RX-48")) {
        printf( "We're an N810 WiMax\n");
        appdata->device_type = DEVICE_N810; // wimax one, thanks Qwerty :)
        appdata->frame_height = HEIGHT;
        appdata->frame_width = WIDTH;
    } else if (strstr(d, "RX-51")) {
        printf( "We're an N900\n");
        appdata->device_type = DEVICE_N900;
        appdata->frame_height = HEIGHT; //N900_HEIGHT;
        appdata->frame_width = WIDTH; //N900_WIDTH;
    } else
        printf( "We're something else");
}


