#ifndef Wifi_H
#define Wifi_H

#include <QObject>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

class PluginAction;
class WifiSink;
class MaemoBarcodeWindow;

class WifiPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    void initInterface(QWidget *parent);

    QSet<PluginAction*> getPluginActions();
    QString getName() { return "Wifi opener"; }

private:
    QWidget *parent;
    WifiSink *sink;
};

class WifiInfo
{
public:
    enum Type
    {
        Type_Open,
        Type_WEP,
        Type_WPA
    };
    WifiInfo()
    {
        type = Type_Open;
    }

    Type type;
    QString essid;
    QString key;
};
class WifiSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    WifiSink(const PluginInterface *interface);

    QString getName() { return "Wifi sink plugin"; }
    QString getText();
    bool isReady();
    void clickAction(QWidget *parentWindow);

private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);

private:
    bool extractPiece(QStringList& pieces, QString key, QString& value);
    bool parseWifiString(QString str, WifiInfo& info);

    static bool createAndConnectIAP(WifiInfo info, QString& error);

    bool ready;
    WifiInfo wifiInfo;
};

#endif //Wifi_H
