#include <QtDBus>
#include <QtGui>

#include "providerwindow.h"
#include "ui_providerwindow.h"

#include "searchprovider.h"
#include "wrplugin.h"
#include "editproviderdialog.h"
#include "htmldelegate.h"

ProviderWindow::ProviderWindow(QWidget *parent, WrPlugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::ProviderWindow)
{
    qDebug() << "ProviderWindow::ProviderWindow()";
    ui->setupUi(this);
    ui->menuMenu->setTitle("");
    this->plugin = plugin;
    model = new QStandardItemModel(this);
    ui->tblProviders->setModel(model);
    ui->tblProviders->setProperty("FingerScrollable", true);
    delegate = new HtmlDelegate();
    ui->tblProviders->setItemDelegateForColumn(0,delegate);
    ui->tblProviders->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    editMode = false;
    refreshProviders();
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

ProviderWindow::~ProviderWindow()
{
    delete ui;
}

void ProviderWindow::refreshProviders() {
    qDebug() << "Refreshing providers";
    model->clear();
    int row = 0;
    for(int i = 0; i<plugin->searchProviders().count(); i++) {
        SearchProvider* provider = plugin->searchProviders().at(i);
        QVariantHash itemData;
        itemData.insert("baseUri", provider->baseUri);
        itemData.insert("providerId", i);

        QStandardItem *providerItem = new QStandardItem(provider->name + "<br/><span style='font-size: small; color: grey'>" +
                                                        provider->baseUri.replace("%s", plugin->barcodeText) + "</span>");
        providerItem->setData(itemData);
        model->setItem(row, 0, providerItem);

        if(editMode) {
            QStandardItem *removeItem = new QStandardItem("Remove");
            removeItem->setData(itemData);
            model->setItem(row, 1, removeItem);
        }
        row++;
    }
    ui->tblProviders->resizeRowsToContents();
    qDebug() << "Providers refreshed";
}

void ProviderWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ProviderWindow::on_tblProviders_clicked(QModelIndex index)
{
    qDebug() << "Clicked on table";
    QStandardItem *item = model->itemFromIndex(index);
    QVariantHash itemData = item->data().toHash();
    QString baseUri = itemData.value("baseUri").toString();
    int providerId = itemData.value("providerId").toInt();
    qDebug() << "Checking column";
    if(item->column() == 0 && !editMode) { // open the link
        if(!editMode) {
            QString uri = baseUri.replace("%s", QUrl::toPercentEncoding(plugin->barcodeText)); // replace %s with barcodeText
            QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
            interface->call("open_new_window",uri);
        }
    } else if(item->column() == 0 && editMode) { // edit the provider
        EditProviderDialog *dialog = new EditProviderDialog(this, plugin->searchProviders().at(providerId));
        if(dialog->exec() == QDialog::Accepted) {
            QList<SearchProvider*> providers = plugin->searchProviders();
            providers.at(providerId)->baseUri = dialog->providerAddress();
            providers.at(providerId)->name = dialog->providerName();
            plugin->setSearchProviders(providers);
            refreshProviders();
        }
    } else if(item->column() == 1 && editMode) { // delete the provider
        QMessageBox *prompt = new QMessageBox(this);
        prompt->setWindowTitle("Remove search provider?");
        prompt->setText("Are you sure you want to remove this search provider?");
        prompt->setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        if(prompt->exec() == QMessageBox::Ok) {
            plugin->removeSearchProvider(plugin->searchProviders().at(providerId));
            refreshProviders();
        }
    }
    qDebug() << "done click";
//    this->close();
}

void ProviderWindow::on_actionAdd_Custom_Search_triggered()
{
    EditProviderDialog *dialog = new EditProviderDialog(this);
    if(dialog->exec() == QDialog::Accepted) {
        plugin->addSearchProvider(new SearchProvider(dialog->providerName(), dialog->providerAddress()));
        refreshProviders();
    }
}

void ProviderWindow::on_actionEdit_mode_triggered()
{
    editMode = !editMode;
    refreshProviders();
    if(editMode) {
        ui->actionEdit_mode->setText("End Editing");
    } else {
        ui->actionEdit_mode->setText("Edit Providers");
    }
}
