#ifndef TESTSINK_H
#define TESTSINK_H

#include <QtCore>
#include <QImage>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

class WrPlugin;

class WrSink : public QObject, public SinkPlugin
{
    Q_OBJECT
public:
    // inherited virtuals
    WrSink(const PluginInterface *interface);
    QString getName() {return "Webrequest sink";};
    QString getText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
    void setPlugin(WrPlugin* plugin);
    // other
    //QString url;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    bool ready;
    QString buttonText;
    QString barcodeText;
    int type;
    WrPlugin *plugin;
    // other
};

#endif // TESTSINK_H
