#include "editproviderdialog.h"
#include "ui_editproviderdialog.h"

#include "searchprovider.h"

EditProviderDialog::EditProviderDialog(QWidget *parent, SearchProvider *provider) :
        QDialog(parent),
        ui(new Ui::EditProviderDialog)
{
    ui->setupUi(this);
    if(provider != NULL) {
        setWindowTitle("Edit Search Provider");
        ui->txtName->setText(provider->name());
        ui->txtAddress->setText(provider->baseUri());
    } else {
        setWindowTitle("Add Search Provider");
    }
}

EditProviderDialog::~EditProviderDialog()
{
    delete ui;
}

void EditProviderDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QString EditProviderDialog::providerName() {
    return ui->txtName->text();
}

QString EditProviderDialog::providerAddress() {
    return ui->txtAddress->text();
}
