#include <QtGui>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <mbarcode-qt/maemobarcodewindow.h>

#include "wrplugin.h"
#include "wrsink.h"
#include "searchprovider.h"

void WrPlugin::initInterface(QWidget *parent) {
    settings = new QSettings("mbarcode", "webrequest-plugin", this);
    sink = new WrSink(this);
    sink->setPlugin(this);
    connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)),
            this, SLOT(barcodeAnalysed(QString,QString)));
    barcodeText = "No barcode analysed yet";
    int size = settings->beginReadArray("searchProviders");
    for(int i = 0; i < size; i++) {
        settings->setArrayIndex(i);
        providers.append(new SearchProvider(settings->value("name","Unknown provider").toString(), settings->value("baseUri","%s").toString()));
    }
    settings->endArray();
}

QSet<PluginAction*> WrPlugin::getPluginActions() {
    QSet<PluginAction*> newList;
    newList.insert(sink);
    return newList;
}

QList<SearchProvider*> WrPlugin::searchProviders() {
    QList<SearchProvider*> allProviders;
    if(settings->value("defaultValuesCreated", false) == false) { // the program is running for the first time
        allProviders.append(new SearchProvider("Google", "http://www.google.com/search?q=%s"));
        allProviders.append(new SearchProvider("Yahoo", "http://search.yahoo.com/search?p=%s"));
        allProviders.append(new SearchProvider("Amazon UK", "http://www.amazon.co.uk/s/ref=nb_sb_noss?url=search-alias%3Daps&field-keywords=%s"));
        allProviders.append(new SearchProvider("Best Game Price UK", "http://www.best-game-price.co.uk/search-Keywords/1-/300703/%s"));
        allProviders.append(new SearchProvider("Check UPC", "http://www.checkupc.com/search.php?keyword=%s"));
        allProviders.append(new SearchProvider("Froogle", "http://www.google.com/products?q=%s"));
        allProviders.append(new SearchProvider("UPC Database", "http://www.upcdatabase.com/item/%s"));
        allProviders.append(new SearchProvider("EAN Search", "http://www.ean-search.org/perl/ean-search.pl?q=%s"));
        allProviders.append(new SearchProvider("CodeCheck (de)", "http://www.codecheck.info/mobi/results?text=%s"));

        setSearchProviders(allProviders);
        settings->setValue("defaultValuesCreated", true);
    } else {
        allProviders = this->providers;
    }
    return allProviders;
}

void WrPlugin::setSearchProviders(QList<SearchProvider*> providers) {
    this->providers = providers;
    saveSearchProviders();
}

void WrPlugin::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    Q_UNUSED(barcodeType)
    qDebug() << "WrPlugin::barcodeAnalysed() recieved analysed signal" << barcodeData;
    barcodeText = barcodeData;
    sink->barcodeText = barcodeData;
}

void WrPlugin::saveSearchProviders() {
    settings->beginWriteArray("searchProviders");
    for(int i = 0; i < providers.size(); i++) {
        settings->setArrayIndex(i);
        settings->setValue("name", providers.at(i)->name());
        settings->setValue("baseUri", providers.at(i)->baseUri());
    }
    settings->endArray();
}

void WrPlugin::addSearchProvider(SearchProvider *provider) {
    providers.append(provider);
    saveSearchProviders();
}

void WrPlugin::removeSearchProvider(SearchProvider *provider) {
    providers.removeAll(provider);
    saveSearchProviders();
}

//QString TestPlugin::getInterfaceName() const {
//    return "Test plugin";
//}
Q_EXPORT_PLUGIN2(mbqt_wrplugin, WrPlugin)
