#ifndef TESTPLUGIN_H
#define TESTPLUGIN_H

#include <QObject>
#include <QStringList>
#include <QImage>

#include <mbarcode-qt/plugininterfaces.h>

class PluginAction;
class MaemoBarcodeWindow;
class WrSink;
class SearchProvider;

class WrPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    void initInterface(QWidget *parent);
    QSet<PluginAction*> getPluginActions();
    QString getName() {return "Webrequest";}
    QSettings *settings;
    QList<SearchProvider*> searchProviders();
    void setSearchProviders(QList<SearchProvider*> providers);
    void saveSearchProviders();
    void addSearchProvider(SearchProvider* provider);
    void removeSearchProvider(SearchProvider* provider);
    QString barcodeText;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    QWidget *parent;
    QString url;
    WrSink *sink;
    QList<SearchProvider*> providers;
};

#endif //TESTPLUGIN_H
