#include "wrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

#include "providerwindow.h"
#include "wrplugin.h"

WrSink::WrSink(const PluginInterface *interface) : SinkPlugin(interface) {
    ready = false;
}

QString WrSink::getText()
{
    return "Search the Web";
}

void WrSink::clickAction(QWidget *parentWindow) {
    ProviderWindow *win = new ProviderWindow(parentWindow, plugin);
    win->show();
}

void WrSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    ready = true;
    plugin->barcodeText = barcodeData;
}

bool WrSink::isReady() {
    return ready;
}

void WrSink::setPlugin(WrPlugin *plugin) {
    this->plugin = plugin;
}
