#ifndef TESTSINK_H
#define TESTSINK_H

#include <QtCore>
#include <QImage>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

class WrSink : public QObject, public SinkPlugin
{
    Q_OBJECT
public:
    // inherited virtuals
    WrSink(const PluginInterface *interface);
    QString getName() {return "Webrequest sink";};
    QString getText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
    // other
    //QString url;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    bool ready;
    QString buttonText;
    QString barcodeText;
    int type;

    enum barcodeType {
        Unknown=0,
        Email,
        URL,
        SMS,
        MMS,
        PhoneNumber,
        vCard,
        BizCard,
        iMode,
        Geo,
        YouTube,
        Install,
        Ovi
    };
    void openGeneric(QString uri);
    void addVCard(QString user_data);
    void openInstallFile(QString data);
    // other
};

#endif // TESTSINK_H
