#include "qrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

QrSink::QrSink(const PluginInterface *interface) : SinkPlugin(interface) {
    ready = false;
}

QString QrSink::getText()
{
    return buttonText;
}

void QrSink::clickAction(QWidget *parentWindow) {
     //QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request",
     //                                               "com.nokia.osso_browser");
     //interface->call("open_new_window",url);

    if(type==QrSink::vCard){

    }else if(type==QrSink::BizCard){

    }else if(type==QrSink::Install){
        openInstallFile(barcodeText);

    }else if(type==QrSink::URL){
        openGeneric(barcodeText);

    }else if(type==QrSink::iMode){
    }else if(type==QrSink::Email){
        openGeneric(barcodeText);

    }else if(type==QrSink::PhoneNumber){
        openGeneric(barcodeText);

    }else if(type==QrSink::SMS){
        openGeneric(barcodeText);

    }else if(type==QrSink::MMS){
        openGeneric(barcodeText);

    }else if(type==QrSink::Geo){
        // we don't do anything with this at the moment, so should it be removed?

    }else if(type==QrSink::YouTube){
    }else if(type==QrSink::Ovi){
        openInstallFile(barcodeText);

    }else if(type==QrSink::Unknown){
        // this is a catch all, as long as we are the last plugin that's tried that's fine
        // but wouldn't want to prevent some other plugin handling something we don't!
    }


}

void QrSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    qDebug(qPrintable("QR-Code plugin got: " + barcodeType + " " + barcodeData));
    if(barcodeType == "QR-Code" || barcodeType == "dmtx") {
        qDebug("That is a QR-code or datamatrix! Let's give the user something to click!");

        buttonText = ""; // reset the text

        // work out what sort of data the code contains here
        // it would be better to parse the data before we display our button, that way we could show the url, email, tel no, etc. on the button
        // something for the improved version... :)

        if (barcodeData.indexOf("BEGIN:VCARD")==0){
            type=this->QrSink::vCard;
            buttonText.append("Click to open vCard");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("BIZCARD:")==0){
            type=this->QrSink::BizCard;
            buttonText.append("Click to open BizCard");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("[install]")==0){
            type=this->QrSink::Install;
            buttonText.append("Click to install package");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("URL:")==0){
            type=this->QrSink::URL;
            buttonText.append("Click to open URL");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("URLTO:")==0){
            type=this->QrSink::URL;
            buttonText.append("Click to open URL");
            barcodeText=barcodeData;
        }else if(barcodeData.contains("http://")){
            type=this->QrSink::URL;
            buttonText.append("Click to open URL");
            barcodeText=barcodeData; // need to find where the http:// occurs in the string and trim it!

        }else if(barcodeData.indexOf("CNTS:")==0){
            type=this->QrSink::iMode;
            buttonText.append("Click to open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MECARD:")==0){
            type=this->QrSink::iMode;
            buttonText.append("Click to open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MATMSG:")==0){
            type=this->QrSink::iMode;
            buttonText.append("Click to open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MEBKM:")==0){
            type=this->QrSink::iMode;
            buttonText.append("Click to open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("LAPL:")==0){
            type=this->QrSink::iMode;
            buttonText.append("Click to open iMode data");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("mailto:")==0){
            type=this->QrSink::Email;
            buttonText.append("Click to email");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("tel:")==0){
            type=this->QrSink::PhoneNumber;
            buttonText.append("Click to use phone number");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("sms:")==0){
            type=this->QrSink::SMS;
            buttonText.append("Click to open SMS");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("smsto:")==0){
            type=this->QrSink::SMS;
            buttonText.append("Click to open SMS");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("mms:")==0){
            type=this->QrSink::MMS;
            buttonText.append("Click to open MMS");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("mmsto:")==0){
            type=this->QrSink::MMS;
            buttonText.append("Click to open MMS");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("geo:")==0){
            type=this->QrSink::Geo;
            buttonText.append("Click to open geo location");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("youtube:")==0){
            type=this->QrSink::YouTube;
            buttonText.append("Click to open YouTube link");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("ovi:")==0){
            type=this->QrSink::Ovi;
            buttonText.append("Click to install from Ovi");
            barcodeText=barcodeData;

        }else{
            type=this->QrSink::Unknown;
            buttonText.append("Click to view text");
            barcodeText=barcodeData;
        }


        ready = true;
    } else {
        ready = false;
    }
}

bool QrSink::isReady() {
    return ready;
}





// uses GLib, need to convert to pure Qt
void QrSink::openInstallFile(QString data)
{
//    FILE *install_file;
//    gchar *data = g_strdup(data1);
//    char *filename=NULL;
//    char *p, *pp, *s, *e;
//
//    FILE *fid;
//
//    fid = fopen("/home/user/mbarcode.debug", "w+");
//    fprintf(fid,"Start\n");
//    fflush(fid);
//
//    // decide on a file name for our install file
//
//    // first see if this is an install file for a package or for a repo only
//    p = strstr(data, "package"); // see if we find the keyword "package"
//    if(p){
//        fprintf(fid,"First loop found text\n");
//        fflush(fid);
//        p = strstr(p, "="); // if so, look for the "="
//        if(p){
//            p++; // skip past the =
//            // find the end of the line, so we can work out the name (it might have spaces)
//            s = strstr(p,"\r");
//            if(!s)
//                s = strstr(p,"\n");
//
//            if(!s)
//                pp = g_strdup(p); // no line breaks found apparently
//            else
//                pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//
//            // assume we've now found the package name between p and the end of the string
//            // get rid of white space on both ends
//            fprintf(fid,"First loop about to strip\n");
//            fflush(fid);
//            pp = g_strstrip(pp);
//
//            fprintf(fid,"First loop about to remove spaces\n");
//            fflush(fid);
//            // remove any spaces in the name
//            e = strstr(pp," ");
//            while(e){
//                e[0] = '_';
//                e = strstr(pp," ");
//            }
//
//            fprintf(fid,"First loop generating filename: %s\n", pp);
//            fflush(fid);
//            //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//            filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//            g_free(pp);
//
//        }else{ // something wrong here
//            fprintf(fid,"First loop no =\n");
//            fflush(fid);
//        }
//
//    }
//
//
//    fprintf(fid,"Left first loop\n");
//    fflush(fid);
//
//    if(!filename){
//        // it might just have been a repo, so try to extract this name now
//        p = strstr(s, "repo_name"); // see if we find the keyword "package"
//        if(p){
//            fprintf(fid,"Second loop found text\n");
//            fflush(fid);
//            p = strstr(p, "="); // if so, look for the "="
//            if(p){
//                p++; // skip past the =
//                // find the end of the line, so we can work out the name (it might have spaces)
//                s = strstr(p,"\r");
//                if(!s)
//                    s = strstr(p,"\n");
//
//                if(!s)
//                    pp = g_strdup(p); // no line breaks found apparently
//                else
//                    pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//                // assume we've now found the package name between p and the end of the string
//                // get rid of white space on both ends
//                fprintf(fid,"First loop about to strip\n");
//                fflush(fid);
//                pp = g_strstrip(pp);
//
//                // remove any spaces in the name
//                fprintf(fid,"Second loop about to remove spaces\n");
//                fflush(fid);
//                e = strstr(pp," ");
//                while(e){
//                    e[0] = '_';
//                    e = strstr(pp," ");
//                }
//
//                fprintf(fid,"Second loop generating filename: %s\n", pp);
//                fflush(fid);
//                //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//                filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//                g_free(pp);
//
//            }else{ // something wrong here
//                fprintf(fid,"Second loop no =\n");
//                fflush(fid);
//
//            }
//        }
//    }
//
//    fprintf(fid,"Left second loop\n");
//    fflush(fid);
//
//
//    if(!filename){
//        // we'll just have to generate a filename now it seems
//        //filename = g_strdup_printf("%s//%s.install", getenv ("MYDOCSDIR"), tmpnam(NULL));
//        filename = g_strdup_printf("/home/user/MyDocs/%s.install", tmpnam(NULL));
//        fflush(fid);
//        fprintf(fid,"Generating random filename\n");
//    }
//
//    /*
//    // see if it already exists
//    install_file = fopen(filename, "r");
//    if(install_file){
//        // it already exists!
//        fclose(install_file);
//    }
//    */
//
//
//    if((install_file = fopen(filename, "w+")) == NULL){
//        fprintf(fid,"Failed to open filename\n");
//        fflush(fid);
//        g_free(filename);
//        g_free(data);
//        return; // and give up, for want of a better way of recovering...
//    }
//
//    fprintf(fid,"Writing data\n");
//    fflush(fid);
//
//    fwrite(data, 1, strlen(data), install_file);
//    fclose(install_file);
//
//    fprintf(fid,"about to openGeneric()\n");
//    fflush(fid);
//
//    openGeneric(filename, "Open install file: %s?");
//
//    fclose(fid);
//    g_free(filename);
//    g_free(data);

}


void QrSink::openGeneric(QString uri)
{
    //action = hildon_uri_get_default_action_by_uri(uri, &error);
    //hildon_uri_open(uri, action, &error); //hildon_uri_open (uri, HILDON_URI_ACTION_NORMAL, error);
    //QDesktopServices::openUrl(uri);

    // DBus is currently the only way that does not open a new browser when we want to open a new window...
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
    interface->call("open_new_window",uri);
}


// this uses GLib stuff, I suppose we should try to convert it to use Qt completely.....
void QrSink::addVCard(QString user_data)
{
//    char *vcard = (char*)user_data.constData();
//    OssoABookContact *contact;
//    GError *error = NULL;
//    EBook *book = NULL;
//    book = osso_abook_system_book_dup_singleton (TRUE, NULL);
//    g_return_val_if_fail (E_IS_BOOK (book), FALSE);
//
//    if (!vcard)
//        return;
//
//    contact = osso_abook_contact_new_from_vcard (NULL, vcard);
//    g_assert (OSSO_ABOOK_IS_CONTACT (contact));
//
//    if (!e_book_add_contact (book, E_CONTACT (contact), &error)) {
//            g_warning ("%s: %s", G_STRLOC, error->message);
//            g_assert_not_reached ();
//    }
}


