#ifndef PYTHONQTWRAPPERSINK_H
#define PYTHONQTWRAPPERSINK_H
#include <Python.h>

#include <QObject>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>


class PythonQTWrapperPlugin;

class PythonQTWrapperSink : public PluginAction //public QObject, // removed as otherwise we get direct base inaccessible due to ambiguity, etc
{
    Q_OBJECT
public:
    PythonQTWrapperSink(const PluginInterface *interface, PyObject* sinkInstance/*, QObject *obj, QWidget *widg*/);
    QString getName();
    QString getText();
    QImage getImage();
    QString getInformativeText();
    //bool isReady();
    void clickAction(QWidget *parentWindow);

    void checkIfReady();

signals:
    void isReady();

private:
    QString sinkBarcodeType;
    QString sinkBarcodeData;
    QString pluginName;

    PyObject* sinkInstance;
    //QObject* obj;
    //QWidget *widg;

    PythonQTWrapperPlugin *plugin;

private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);

};

#endif // PYTHONQTWRAPPERSINK_H
