#ifndef PYTHONQTWRAPPERSINK_H
#define PYTHONQTWRAPPERSINK_H
#include <Python.h>

#include <QObject>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>


class PythonQTWrapperPlugin;

class PythonQTWrapperSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    PythonQTWrapperSink(const PluginInterface *interface, PyObject* sinkInstance/*, QObject *obj, QWidget *widg*/);
    QString getName();
    QString getText();
    QImage getImage();
    QString getInformativeText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
private:
    QString sinkBarcodeType;
    QString sinkBarcodeData;
    QString pluginName;

    PyObject* sinkInstance;
    //QObject* obj;
    //QWidget *widg;

private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
};

#endif // PYTHONQTWRAPPERSINK_H
