#include <Python.h>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include "pythonqtwrapperplugin.h"
#include "pythonqtwrappersink.h"

#include <QtDBus>

PythonQTWrapperSink::PythonQTWrapperSink(const PluginInterface *interface, PyObject* sinkInstance) : PluginAction(interface)
{
    this->sinkInstance=sinkInstance;
}

QString PythonQTWrapperSink::getName() // this does not change, so we save the name and can then return it with less overhead
{
    if(pluginName.length()>0)
        return pluginName;

    // get class method
    //qDebug() << "PythonQTWrapperSink just called getName()";

    char method_name[] = "getName";
    PyObject *output = PyObject_CallMethod(this->sinkInstance, method_name, NULL);
    if (output != NULL){
        char *str = PyString_AsString(output);
        if(str){
            pluginName.append(str);
            //qDebug() << "PythonQTWrapperSink::getName() returning " << myname;
        }else
            if ( PyErr_Occurred() )
                PyErr_Print();
    }else{
        if ( PyErr_Occurred() )
            PyErr_Print();
    }
    Py_DECREF(output);
    return pluginName;
};

QString PythonQTWrapperSink::getText()
{
    QString mytext("");
    char method_name[] = "getText";
    // get class method
    //qDebug() << "PythonQTWrapperSink just called getText()";

    PyObject *output = PyObject_CallMethod(this->sinkInstance, method_name, NULL);

    if (output != NULL){
        char *str = PyString_AsString(output);
        if(str){
            mytext.append(str);
            //qDebug() << "PythonQTWrapperSink::getText() returning " << mytext;
        }else
            if ( PyErr_Occurred() )
                PyErr_Print();
    }else{
        if ( PyErr_Occurred() )
            PyErr_Print();
    }
    Py_DECREF(output);
    return mytext;
}

QImage PythonQTWrapperSink::getImage()
{
    QImage myimage;
    char method_name[] = "getImage";
    //qDebug() << "PythonQTWrapperSink just called getImage()";

    // get class method
    //PyObject *output = PyObject_CallMethod(this->sinkInstance, method_name, NULL);

    return myimage;
}


QString PythonQTWrapperSink::getInformativeText() {
    QString mytext("");
    char method_name[] = "getInformativeText";
    // get class method
    //qDebug() << "PythonQTWrapperSink just called getInformativeText()";

    PyObject *output = PyObject_CallMethod(this->sinkInstance, method_name, NULL);

    if (output != NULL){
        char *str = PyString_AsString(output);
        if(str){
            mytext.append(str);
            //qDebug() << "PythonQTWrapperSink::getInformativeText() returning " << mytext;
        }else
            if ( PyErr_Occurred() )
                PyErr_Print();
    }else{
        if ( PyErr_Occurred() )
            PyErr_Print();
    }
    Py_DECREF(output);
    return mytext;
}

bool PythonQTWrapperSink::isReady()
{
    bool ready = false;
    char method_name[] = "isReady";

    //qDebug() << "PythonQTWrapperSink just called isReady()";

    // get class method
    PyObject *output = PyObject_CallMethod(this->sinkInstance, method_name, NULL);

    if (output != NULL){
        ready = (bool)PyInt_AsLong(output); // output will be -1 if an error occurred, but that works for us
        //qDebug() << "PythonQTWrapperSink::isReady() returning " << ready;
        if ( PyErr_Occurred() )
            PyErr_Print();
    }else{
        if ( PyErr_Occurred() )
            PyErr_Print();
    }
    Py_DECREF(output);
    return ready;
}

void PythonQTWrapperSink::clickAction(QWidget *parentWindow)
{
    // call the plugin's main Python method here
    char method_name[] = "clickAction";
    PyObject_CallMethod(this->sinkInstance, method_name, NULL);
    qDebug() << "PythonQTWrapperSink just called clickAction()";
}

void PythonQTWrapperSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {

    char method_name[] = "barcodeAnalysed";
    char format[] = "(ss)";
    qDebug() << "PythonQT Wrapper plugin got: " << barcodeType << " " << barcodeData;

    this->sinkBarcodeType = barcodeType;
    this->sinkBarcodeData = barcodeData;

    PyObject_CallMethod(this->sinkInstance, method_name, format, this->sinkBarcodeType.toUtf8().constData(), this->sinkBarcodeData.toUtf8().constData()); // unicode, unicode - check this is ok
    qDebug() << "PythonQT Wrapper plugin just called barcodeAnalysed()";

}

