#ifndef PYTHONQTWRAPPERSINK_H
#define PYTHONQTWRAPPERSINK_H

#include <QObject>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <PythonQt.h>

class PythonQTWrapperPlugin;

class PythonQTWrapperSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    PythonQTWrapperSink(const PluginInterface *interface, QString sinkName, QString sinkText, QImage image, PythonQtObjectPtr PythonPluginContext);
    QString getName();
    QString getText();
    QImage getImage();
    QString getInformativeText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
private:
    QString sinkBarcodeType;
    QString sinkBarcodeData;

    QStringList soughtBarcodeTypes;
    QString barcodeContentRegex;
    QString myname; // to return from getName()
    QString mytext; // to return from getText()
    PythonQtObjectPtr PythonPluginContext;
    QImage image;

    bool ready;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
};

#endif // PYTHONQTWRAPPERSINK_H
