

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include "pythonqtwrapperplugin.h"
#include "pythonqtwrappersink.h"
#include <PythonQt.h>

#include <QtDBus>

PythonQTWrapperSink::PythonQTWrapperSink(const PluginInterface *interface, QString sinkName,
                                   QString sinkText,
                                   QImage image,
                                   PythonQtObjectPtr PythonPluginContext) : PluginAction(interface)
{
    ready = false;

    // this function will be passed all relevant information for the sink class
    // i.e. name and description text
    // barcode type(s) and match !match information

    this->myname = sinkName;
    this->mytext = sinkText;
    this->soughtBarcodeTypes = soughtBarcodeTypes;
    this->PythonPluginContext = PythonPluginContext;
    this->image = image; // return the correct image from the Python plugin
    this->image = this->image.scaledToHeight(48, Qt::SmoothTransformation);
}

QString PythonQTWrapperSink::getName()
{
    return myname;
};

QString PythonQTWrapperSink::getText()
{
   return mytext; // set our app name here!
}

QImage PythonQTWrapperSink::getImage()
{
   return image; // set our app name here!
}

QString PythonQTWrapperSink::getInformativeText() {
    return sinkBarcodeData.left(30) + "...";
}

bool PythonQTWrapperSink::isReady()
{
    return ready;
}

void PythonQTWrapperSink::clickAction(QWidget *parentWindow)
{
    // call the plugin's main Python method here
    // still need to decide on the structure of the Python-side code

    QString fnName = QString("HandleBarcode");
    QVariantList args;
    args << sinkBarcodeType << sinkBarcodeData;
    this->PythonPluginContext.call(fnName, args);
}

void PythonQTWrapperSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {

    // first look at the specifics of the barcode that we have been passed.
    // see if it matches what this particular sink wants to look at

//    bool found=false;
//    foreach (QString s, soughtBarcodeTypes)
//    {
//        if(barcodeType == s.trimmed())
//        {
//            found=true;
//            break;
//        }
//    }
    qDebug() << "PythonQT Wrapper plugin got: " << barcodeType << " " << barcodeData;

    QString fnName = QString("CheckBarcode");
    QVariantList args;
    args << barcodeType << barcodeData;
    bool output = this->PythonPluginContext.call(fnName, args).toBool();

    if(output) {
        ready = true;
        qDebug() << "PythonQT Wrapper plugin wishes to handle this payload";
        // save the information so we can use it later if we are called
        sinkBarcodeType = barcodeType;
        sinkBarcodeData = barcodeData;
    }else
        qDebug() << "PythonQT Wrapper plugin does not wish to handle this payload";
}

