#ifndef ISBN_H
#define ISBN_H

#include <QObject>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

class PluginAction;
class ISBNSink;
class MaemoBarcodeWindow;

class ISBNPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    void initInterface(QWidget *parent);

    QSet<PluginAction*> getPluginActions();
    QString getName() { return "ISBN opener"; }

private:
    QWidget *parent;
    ISBNSink *sink;
};

class ISBNSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    ISBNSink(const PluginInterface *interface);

    QString getName() { return "ISBN sink plugin"; }
    QString getText();
    bool isReady();
    void clickAction(QWidget *parentWindow);

private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);

private:
    void openBrowser(QString isbn);

    QString convertISBN13to10(QString isbn);

    bool ready;
    QString isbn;
};

#endif //ISBN_H
