#ifndef PLUGIN_H
#define PLUGIN_H

#include <QObject>
#include <QSettings>
#include <QtNetwork>

#include <mbarcode-qt/plugininterfaces.h>

class GetOpinionWindow;
class GiveOpinionWindow;
class AuthenticationWindow;
class GetOpinionSink;
class GiveOpinionSink;
class Plugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    void initInterface(QWidget *parent);
    QSet<PluginAction*> getPluginActions();
    QString getName() {return "Informed Individual";}
    bool hasSettingsWindow() {return true;}
    QMainWindow* getSettingsWindow(QWidget *parent);

    enum NextAction {GetOpinion, GiveOpinion};

    QString barcodeType;
    QString barcodeData;
    QSettings *settings;


    QString consumerKey;
    QString consumerSecret;
    QString baseUrl;
    QString getTimestamp();

    QNetworkAccessManager *manager;

    bool authenticated;
    void checkAuthentication(QWidget *nextWidget, NextAction nextAction);
    QString generateOAuthData();
private slots:
    void replyFinished(QNetworkReply* reply);
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    GetOpinionSink *getOpinionSink;
    GiveOpinionSink *giveOpinionSink;
    NextAction nextAction;
    QWidget *nextWidget;
};

#endif // PLUGIN_H
